/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.cluster;

import com.google.common.base.Strings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.mqtt.cluster.MqttConnectionManager;
import org.joyqueue.broker.mqtt.connection.MqttConnection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttProducerManager
extends Service {
    private static final Logger LOG = LoggerFactory.getLogger(MqttProducerManager.class);
    private ConcurrentMap<String, Producer> producers = new ConcurrentHashMap<String, Producer>();
    private MqttConnectionManager connectionManager;

    public MqttProducerManager(MqttConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void removeProducer(String clientID) {
        MqttConnection connection;
        ConcurrentMap<String, ConcurrentMap<String, String>> topicProducers;
        if (this.connectionManager.isConnected(clientID) && (topicProducers = (connection = this.connectionManager.getConnection(clientID)).getProducers()) != null) {
            for (String topic : topicProducers.keySet()) {
                ConcurrentMap applicationProducers = (ConcurrentMap)topicProducers.get(topic);
                if (applicationProducers == null) continue;
                for (String application : applicationProducers.keySet()) {
                    String producerId = (String)applicationProducers.get(application);
                    if (Strings.isNullOrEmpty((String)producerId)) continue;
                    this.producers.remove(producerId);
                }
            }
        }
    }

    public Producer getProducer(String clientID, String application, String topic) {
        Producer producer = null;
        if (this.connectionManager.isConnected(clientID) && (producer = (Producer)this.producers.get(this.generateProducerId(clientID, topic, application))) == null) {
            MqttConnection connection = this.connectionManager.getConnection(clientID);
            String producerId = connection.getProducer(application, topic);
            if (Strings.isNullOrEmpty((String)producerId)) {
                producerId = this.generateProducerId(clientID, topic, application);
                producer = new Producer();
                producer.setId(producerId);
                producer.setConnectionId(connection.getId());
                producer.setApp(application);
                producer.setTopic(topic);
                producer.setType(Producer.ProducerType.MQTT);
                Producer oldProducer = this.producers.putIfAbsent(producerId, producer);
                if (oldProducer != null) {
                    producer = oldProducer;
                    connection.addProducer(topic, application, producerId);
                }
            } else {
                return (Producer)this.producers.get(producerId);
            }
        }
        return producer;
    }

    private String generateProducerId(String clientID, String topic, String application) {
        return String.format("%s_producer_%s_%s", clientID, application, topic);
    }
}

