/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.cluster;

import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.mqtt.cluster.MqttConnectionManager;
import org.joyqueue.broker.mqtt.session.MqttSession;
import org.joyqueue.broker.mqtt.subscriptions.MqttSubscription;
import org.joyqueue.broker.mqtt.subscriptions.TopicFilter;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.NameService;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSessionManager
extends Service {
    private static final Logger LOG = LoggerFactory.getLogger(MqttSessionManager.class);
    private MqttConnectionManager connectionManager;
    private final ConcurrentMap<String, MqttSession> sessions = new ConcurrentHashMap<String, MqttSession>();
    private NameService nameService;

    public MqttSessionManager(BrokerContext brokerContext, MqttConnectionManager connectionManager) {
        this.nameService = brokerContext.getNameService();
        this.connectionManager = connectionManager;
    }

    public MqttSession getSession(String clientID) {
        MqttSession session = (MqttSession)this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client: <{}>", (Object)clientID);
        }
        return session;
    }

    public void addSession(String clientID, boolean cleanSession) {
        MqttSession session;
        if (this.sessions.containsKey(clientID)) {
            session = (MqttSession)this.sessions.get(clientID);
            if (session.isCleanSession() != cleanSession) {
                session.setCleanSession(cleanSession);
            }
        } else {
            MqttSession innerSession = new MqttSession(clientID, cleanSession);
            this.sessions.put(clientID, innerSession);
        }
        if (!cleanSession) {
            session = (MqttSession)this.sessions.get(clientID);
            String clientGroupName = this.connectionManager.getConnection(clientID).getClientGroupName();
            Set topicNames = this.nameService.getTopics(clientGroupName, Subscription.Type.CONSUMPTION);
            if (topicNames != null && topicNames.size() > 0) {
                for (String topic : topicNames) {
                    MqttSubscription subscription = new MqttSubscription(clientID, new TopicFilter(topic), MqttQoS.AT_LEAST_ONCE);
                    session.addSubscription(subscription);
                }
                LOG.info("Persistent client group: <{}>, recovery session: {}", (Object)clientGroupName, (Object)session);
            }
        }
    }

    public void removeSession(String clientID) {
        MqttSession session = (MqttSession)this.sessions.get(clientID);
        if (session != null) {
            if (session.isCleanSession()) {
                String clientGroupName = this.connectionManager.getConnection(clientID).getClientGroupName();
                Set<MqttSubscription> subscriptions = session.listSubsciptions();
                ArrayList<Subscription> unSubscriptionList = new ArrayList<Subscription>(subscriptions.size());
                for (MqttSubscription subscription : subscriptions) {
                    unSubscriptionList.add(new Subscription(TopicName.parse((String)subscription.getTopicFilter().toString()), clientGroupName, Subscription.Type.CONSUMPTION));
                }
                this.nameService.unSubscribe(unSubscriptionList);
            }
            this.sessions.remove(clientID);
        }
    }

    public boolean contains(String clientID) {
        return this.sessions.containsKey(clientID);
    }

    public Map<String, MqttSession> listSessions() {
        return this.sessions;
    }
}

