/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.cluster;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.mqtt.subscriptions.MqttSubscription;
import org.joyqueue.broker.mqtt.subscriptions.TopicFilter;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.NameService;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSubscriptionManager
extends Service {
    private static Logger LOG = LoggerFactory.getLogger(MqttSubscriptionManager.class);
    private Set<String> topics = new ConcurrentSet();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private NameService nameService;

    public MqttSubscriptionManager(BrokerContext brokerContext) {
        this.nameService = brokerContext.getNameService();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduler.scheduleWithFixedDelay(new ScheduledTopicsUpdater(), 0L, 60L, TimeUnit.SECONDS);
        LOG.info("subscribe service is started.");
    }

    protected void doStop() {
        super.doStop();
    }

    public Set<MqttSubscription> subscribes(String clientGroupName, List<MqttSubscription> topicFilters) throws Exception {
        HashSet<MqttSubscription> needSubscriptions = new HashSet<MqttSubscription>();
        if (topicFilters == null || topicFilters.isEmpty()) {
            LOG.info("Subscribe topic list empty, please check topicFilters: {}", topicFilters);
            return needSubscriptions;
        }
        this.filterTopics(needSubscriptions, topicFilters);
        if (needSubscriptions.isEmpty()) {
            LOG.info("Subscribe topic list empty, please check topicFilters: {}", topicFilters);
            return needSubscriptions;
        }
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(needSubscriptions.size());
        for (MqttSubscription subscription : needSubscriptions) {
            subscriptionList.add(new Subscription(TopicName.parse((String)subscription.getTopicFilter().toString()), clientGroupName, Subscription.Type.CONSUMPTION));
        }
        this.nameService.subscribe(subscriptionList, ClientType.MQTT);
        return needSubscriptions;
    }

    public void unSubscribe(String clientGroupName, Set<MqttSubscription> topicFilters) throws Exception {
        if (topicFilters == null || topicFilters.isEmpty()) {
            LOG.info("UnSubscribe topic list empty, please check topicFilters: {}", topicFilters);
        }
        ArrayList<Subscription> unSubscriptionList = new ArrayList<Subscription>(topicFilters.size());
        for (MqttSubscription subscription : topicFilters) {
            unSubscriptionList.add(new Subscription(TopicName.parse((String)subscription.getTopicFilter().toString()), clientGroupName, Subscription.Type.CONSUMPTION));
        }
        this.nameService.unSubscribe(unSubscriptionList);
    }

    private void filterTopics(Set<MqttSubscription> list, List<MqttSubscription> topicFilters) {
        if (this.topics.size() == 0) {
            list.addAll(topicFilters);
        } else {
            for (MqttSubscription subscription : topicFilters) {
                for (String topic : this.topics) {
                    TopicFilter newTopicFilter = new TopicFilter(topic);
                    try {
                        if (!newTopicFilter.match(subscription.getTopicFilter())) continue;
                        MqttSubscription newSubscription = new MqttSubscription(subscription.getClientId(), newTopicFilter, subscription.getRequestedQos());
                        list.add(newSubscription);
                    }
                    catch (Exception e) {
                        LOG.error("Topic meta data <{}> filter match subscription <{}> filter error: {}", new Object[]{topic, subscription.getTopicFilter(), e});
                    }
                }
            }
        }
    }

    private class ScheduledTopicsUpdater
    implements Runnable {
        private ScheduledTopicsUpdater() {
        }

        @Override
        public void run() {
            Set origTopics = MqttSubscriptionManager.this.nameService.getAllTopicCodes();
            if (origTopics != null && origTopics.size() > 0) {
                LOG.info("Topic updater data size: {}", (Object)origTopics.size());
                for (String tn : origTopics) {
                    MqttSubscriptionManager.this.topics.add(tn);
                }
            } else {
                LOG.info("Topic updater data empty.");
            }
        }
    }
}

