/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.config;

import org.joyqueue.broker.mqtt.config.MqttConfigKey;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttConfig.class);
    private PropertySupplier propertySupplier;

    public MqttConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    public String getConnectionThreadPoolName() {
        return (String)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_CONNECTION);
    }

    public String getPingThreadPoolName() {
        return (String)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_PING);
    }

    public String getSubscriptionThreadPoolName() {
        return (String)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_SUBSCRIPTION);
    }

    public String getPublishThreadPoolName() {
        return (String)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_PUBLISH);
    }

    public int getConnectionThreadPoolSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_CONNECTION_THREAD);
    }

    public int getPingThreadPoolSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_PING_THREAD);
    }

    public int getSubscriptionThreadPoolSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_SUBSCRIPTION_THREAD);
    }

    public int getPublishThreadPoolSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_PUBLISH_THREAD);
    }

    public int getConnectionThreadPoolQueueSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_CONNECTION_QUEUESIZE);
    }

    public int getPingThreadPoolQueueSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_PING_QUEUESIZE);
    }

    public int getSubscriptionThreadPoolQueueSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_SUBSCRIPTION_QUEUESIZE);
    }

    public int getPublishThreadPoolQueueSize() {
        return (Integer)this.getConfig(MqttConfigKey.EXECUTOR_SERVICE_PUBLISH_QUEUESIZE);
    }

    public int getMaxPayloadSize() {
        return (Integer)this.getConfig(MqttConfigKey.MAX_PAYLOAD_SIZE);
    }

    protected <T> T getConfig(PropertyDef key) {
        return (T)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)key);
    }
}

