/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joyqueue.broker.mqtt.config.MqttConfig;
import org.joyqueue.broker.mqtt.handler.ConnectHandler;
import org.joyqueue.broker.mqtt.handler.PingReqHandler;
import org.joyqueue.broker.mqtt.handler.PingRespHandler;
import org.joyqueue.broker.mqtt.handler.PublishAckHandler;
import org.joyqueue.broker.mqtt.handler.PublishCompHandler;
import org.joyqueue.broker.mqtt.handler.PublishHandler;
import org.joyqueue.broker.mqtt.handler.PublishRecHandler;
import org.joyqueue.broker.mqtt.handler.PublishRelHandler;
import org.joyqueue.broker.mqtt.handler.SubscribeHandler;
import org.joyqueue.broker.mqtt.handler.UnSubscribeHandler;
import org.joyqueue.broker.mqtt.util.ExecutorServiceFactory;
import org.joyqueue.toolkit.service.Service;

public class MqttContext
extends Service {
    private MqttConfig mqttConfig;
    private Map<Class, ExecutorService> executorServiceMap = new HashMap<Class, ExecutorService>();

    public MqttContext(MqttConfig mqttConfig) {
        this.mqttConfig = mqttConfig;
    }

    private void loadContext() {
        ExecutorService connectExecutor = ExecutorServiceFactory.createExecutorService(this.mqttConfig.getConnectionThreadPoolSize(), this.mqttConfig.getConnectionThreadPoolQueueSize(), this.mqttConfig.getConnectionThreadPoolName());
        this.executorServiceMap.put(ConnectHandler.class, connectExecutor);
        ExecutorService pingExecutor = ExecutorServiceFactory.createExecutorService(this.mqttConfig.getPingThreadPoolSize(), this.mqttConfig.getPingThreadPoolQueueSize(), this.mqttConfig.getPingThreadPoolName());
        this.executorServiceMap.put(PingReqHandler.class, pingExecutor);
        this.executorServiceMap.put(PingRespHandler.class, pingExecutor);
        ExecutorService publishExecutor = ExecutorServiceFactory.createExecutorService(this.mqttConfig.getPublishThreadPoolSize(), this.mqttConfig.getPublishThreadPoolQueueSize(), this.mqttConfig.getPublishThreadPoolName());
        this.executorServiceMap.put(PublishHandler.class, publishExecutor);
        this.executorServiceMap.put(PublishAckHandler.class, publishExecutor);
        this.executorServiceMap.put(PublishRecHandler.class, publishExecutor);
        this.executorServiceMap.put(PublishRelHandler.class, publishExecutor);
        this.executorServiceMap.put(PublishCompHandler.class, publishExecutor);
        ExecutorService subscriptionExecutor = ExecutorServiceFactory.createExecutorService(this.mqttConfig.getSubscriptionThreadPoolSize(), this.mqttConfig.getSubscriptionThreadPoolQueueSize(), this.mqttConfig.getSubscriptionThreadPoolName());
        this.executorServiceMap.put(SubscribeHandler.class, subscriptionExecutor);
        this.executorServiceMap.put(UnSubscribeHandler.class, subscriptionExecutor);
    }

    public MqttConfig getMqttConfig() {
        return this.mqttConfig;
    }

    public Map<Class, ExecutorService> getExecutorServiceMap() {
        return this.executorServiceMap;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.loadContext();
    }

    protected void doStop() {
        super.doStop();
        this.executorServiceMap.forEach((cls, executorService) -> {
            if (!executorService.isTerminated()) {
                executorService.shutdown();
            }
        });
    }
}

