/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.connection;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.network.session.Connection;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.time.SystemClock;

public class MqttConnection
extends Connection {
    private static final String SPLIT = ".";
    private String clientId;
    private String application;
    private String username;
    private String password;
    private String clientGroupName;
    private boolean cleanSession;
    private boolean isWillRetain;
    private int willQos;
    private int mqttVersion;
    private boolean isWillFlag;
    private int keepAliveTimeSeconds;
    private Channel channel;
    private long createdTime;
    private long lastOperateTime;

    public MqttConnection(String clientId, String username, String password, boolean cleanSession, int version, boolean isWillRetain, int willQos, boolean isWillFlag, int keepAliveTimeSeconds, Channel client) {
        this.clientId = clientId;
        this.setId(clientId);
        this.username = username;
        this.password = password;
        this.application = username;
        this.clientGroupName = this.application + SPLIT + clientId;
        this.cleanSession = cleanSession;
        this.mqttVersion = version;
        this.isWillRetain = isWillRetain;
        this.willQos = willQos;
        this.isWillFlag = isWillFlag;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
        this.channel = client;
        this.createdTime = SystemClock.now();
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientGroupName() {
        return this.clientGroupName;
    }

    public void setClientGroupName(String clientGroupName) {
        this.clientGroupName = clientGroupName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public int getKeepAliveTimeSeconds() {
        return this.keepAliveTimeSeconds;
    }

    public boolean isWillRetain() {
        return this.isWillRetain;
    }

    public int getWillQos() {
        return this.willQos;
    }

    public boolean isWillFlag() {
        return this.isWillFlag;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public void setWillRetain(boolean willRetain) {
        this.isWillRetain = willRetain;
    }

    public void setWillQos(int willQos) {
        this.willQos = willQos;
    }

    public void setWillFlag(boolean willFlag) {
        this.isWillFlag = willFlag;
    }

    public void setKeepAliveTimeSeconds(int keepAliveTimeSeconds) {
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public int getMqttVersion() {
        return this.mqttVersion;
    }

    public void setMqttVersion(int mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public long getLastOperateTime() {
        return this.lastOperateTime;
    }

    public void setLastOperateTime(long lastOperateTime) {
        this.lastOperateTime = lastOperateTime;
    }

    public boolean addProducer(String topic, String app, String id) {
        return super.addProducer(topic, app, id);
    }

    public String getProducer(String topic, String app) {
        return super.getProducer(topic, app);
    }

    public boolean containsProducer(String topic, String app) {
        return super.containsProducer(topic, app);
    }

    public boolean addConsumer(String topic, String app, String id) {
        return super.addConsumer(topic, app, id);
    }

    public String getConsumer(String topic, String app) {
        return super.getConsumer(topic, app);
    }

    public boolean containsConsumer(String topic, String app) {
        return super.containsConsumer(topic, app);
    }

    public ConcurrentMap<String, ConcurrentMap<String, String>> getProducers() {
        return super.getProducers();
    }

    public ConcurrentMap<String, ConcurrentMap<String, String>> getConsumers() {
        return super.getConsumers();
    }

    protected ConcurrentMap<String, String> getOrCreateProducers(String app) {
        return super.getOrCreateProducers(app);
    }

    protected ConcurrentMap<String, String> getOrCreateConsumers(String app) {
        return super.getOrCreateConsumers(app);
    }

    public String toString() {
        return "MqttConnection{clientId='" + this.clientId + '\'' + ", application='" + this.application + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", clientGroupName='" + this.clientGroupName + '\'' + ", cleanSession=" + this.cleanSession + ", isWillRetain=" + this.isWillRetain + ", willQos=" + this.willQos + ", mqttVersion=" + this.mqttVersion + ", isWillFlag=" + this.isWillFlag + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", channel=" + this.channel + ", createdTime=" + this.createdTime + ", lastOperateTime=" + this.lastOperateTime + ", address=" + IpUtil.toIp((byte[])this.getAddress()) + ", serverAddress=" + IpUtil.toIp((byte[])this.getServerAddress()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MqttConnection that = (MqttConnection)((Object)o);
        if (this.clientId != null && this.channel != null && this.getAddress() != null) {
            if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
                return false;
            }
            if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) {
                return false;
            }
            return this.getAddress() != null ? Arrays.hashCode(this.getAddress()) == Arrays.hashCode(that.getAddress()) : that.getAddress() == null;
        }
        return false;
    }

    public int hashCode() {
        int result = this.clientId != null ? this.clientId.hashCode() : 0;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + (this.getAddress() != null ? Arrays.hashCode(this.getAddress()) : 0);
        return result;
    }
}

