/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.handler;

import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.ExecutorService;
import org.joyqueue.broker.mqtt.handler.ExecutorsProvider;
import org.joyqueue.broker.mqtt.handler.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectHandler
extends Handler
implements ExecutorsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectHandler.class);

    @Override
    public void handleRequest(Channel client, MqttMessage message) throws Exception {
        MqttConnectMessage connectMessage = (MqttConnectMessage)message;
        this.mqttProtocolHandler.processConnect(client, connectMessage);
    }

    @Override
    public MqttMessageType type() {
        return MqttMessageType.CONNECT;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.mqttContext.getExecutorServiceMap().get(ConnectHandler.class);
    }
}

