/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.util.ReferenceCountUtil;
import org.joyqueue.broker.mqtt.handler.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerExecutor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerExecutor.class);
    private Handler handler;
    private ChannelHandlerContext context;
    private MqttMessage message;

    public HandlerExecutor(Handler handler, ChannelHandlerContext context, MqttMessage message) {
        this.handler = handler;
        this.context = context;
        this.message = message;
    }

    @Override
    public void run() {
        this.execute();
    }

    public void execute() {
        try {
            if (this.handler != null) {
                this.handler.handleRequest(this.context.channel(), this.message);
            }
        }
        catch (Throwable th) {
            LOG.error("HandlerExecutor got exception: ", th);
            this.context.fireExceptionCaught(th);
        }
        finally {
            ReferenceCountUtil.release((Object)this.message);
        }
    }
}

