/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.handler;

import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.mqtt.command.MqttHandlerFactory;
import org.joyqueue.broker.mqtt.config.MqttContext;
import org.joyqueue.broker.mqtt.handler.Handler;
import org.joyqueue.broker.mqtt.handler.MqttProtocolHandler;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttHandlerDispatcher
extends Service {
    private final Logger logger = LoggerFactory.getLogger(MqttHandlerDispatcher.class);
    private Map<MqttMessageType, Handler> handlerMap = new HashMap<MqttMessageType, Handler>();
    private MqttHandlerFactory handlerFactory;
    private MqttProtocolHandler mqttProtocolHandler;
    private MqttContext mqttContext;

    public MqttHandlerDispatcher(CommandHandlerFactory handlerFactory, BrokerContext brokerContext, MqttContext mqttContext) {
        this.handlerFactory = (MqttHandlerFactory)handlerFactory;
        this.mqttProtocolHandler = new MqttProtocolHandler(brokerContext);
        this.mqttContext = mqttContext;
    }

    public Handler getHandler(MqttMessageType type) {
        return this.handlerMap.get(type);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.init();
        this.mqttContext.start();
        this.mqttProtocolHandler.start();
    }

    public void init() {
        for (Handler handler : this.handlerFactory.getHandlers()) {
            handler.setMqttProtocolHandler(this.mqttProtocolHandler);
            handler.setMqttContext(this.mqttContext);
            this.handlerMap.put(handler.type(), handler);
        }
        this.logger.info("MqttHandlerDispatcher started!");
    }

    public MqttProtocolHandler getMqttProtocolHandler() {
        return this.mqttProtocolHandler;
    }
}

