/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.handler;

import com.google.common.base.Strings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.mqtt.cluster.MqttConnectionManager;
import org.joyqueue.broker.mqtt.cluster.MqttConsumerManager;
import org.joyqueue.broker.mqtt.cluster.MqttProducerManager;
import org.joyqueue.broker.mqtt.cluster.MqttSessionManager;
import org.joyqueue.broker.mqtt.cluster.MqttSubscriptionManager;
import org.joyqueue.broker.mqtt.connection.MqttConnection;
import org.joyqueue.broker.mqtt.message.WillMessage;
import org.joyqueue.broker.mqtt.publish.MessagePublisher;
import org.joyqueue.broker.mqtt.session.MqttSession;
import org.joyqueue.broker.mqtt.subscriptions.MqttSubscription;
import org.joyqueue.broker.mqtt.subscriptions.TopicFilter;
import org.joyqueue.broker.mqtt.util.NettyAttrManager;
import org.joyqueue.domain.AppToken;
import org.joyqueue.network.session.Producer;
import org.joyqueue.nsr.NameService;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttProtocolHandler
extends Service {
    private static final Logger LOG = LoggerFactory.getLogger(MqttProtocolHandler.class);
    private ConcurrentMap<String, WillMessage> willStore = new ConcurrentHashMap<String, WillMessage>();
    private MqttConnectionManager connectionManager = new MqttConnectionManager();
    private MqttSessionManager sessionManager;
    private MqttProducerManager producerManager;
    private MqttConsumerManager consumerManager;
    private MqttSubscriptionManager subscriptionManager;
    private MessagePublisher messagePublisher;
    private NameService nameService;

    public MqttProtocolHandler(BrokerContext brokerContext) {
        this.messagePublisher = new MessagePublisher(brokerContext, this.connectionManager);
        this.sessionManager = new MqttSessionManager(brokerContext, this.connectionManager);
        this.producerManager = new MqttProducerManager(this.connectionManager);
        this.consumerManager = new MqttConsumerManager(brokerContext, this.connectionManager, this.sessionManager, this.messagePublisher);
        this.subscriptionManager = new MqttSubscriptionManager(brokerContext);
        this.nameService = brokerContext.getNameService();
    }

    public MqttConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public MqttSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public MqttConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public void start() throws Exception {
        super.start();
        this.connectionManager.start();
        this.sessionManager.start();
        this.producerManager.start();
        this.consumerManager.start();
        this.subscriptionManager.start();
    }

    public void stop() {
        super.stop();
        this.connectionManager.stop();
        this.sessionManager.stop();
        this.producerManager.stop();
        this.consumerManager.stop();
        this.subscriptionManager.stop();
    }

    public void processConnect(Channel client, MqttConnectMessage connectMessage) {
        String clientId = connectMessage.payload().clientIdentifier();
        boolean isCleanSession = connectMessage.variableHeader().isCleanSession();
        if (!connectMessage.variableHeader().name().equals("MQTT") || connectMessage.variableHeader().version() != MqttVersion.MQTT_3_1_1.protocolLevel()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CONN clientID: <{}>, \u7248\u672c\u4e0d\u5bf9\u65ad\u5f00\u8fde\u63a5: <{}>", (Object)clientId, (Object)connectMessage.toString());
            }
            this.sendAckToClient(client, connectMessage, MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION, false);
            return;
        }
        MqttConnectReturnCode resultCode = this.checkAuth(connectMessage);
        if (resultCode != MqttConnectReturnCode.CONNECTION_ACCEPTED || Strings.isNullOrEmpty((String)clientId)) {
            this.sendAckToClient(client, connectMessage, resultCode, false);
            return;
        }
        this.addConnection(client, connectMessage, clientId);
        this.initializeKeepAliveTimeout(client, connectMessage, clientId);
        this.storeWillMessage(clientId, connectMessage);
        this.sessionManager.addSession(clientId, isCleanSession);
        MqttConnAckMessage okResp = this.sendAckToClient(client, connectMessage, MqttConnectReturnCode.CONNECTION_ACCEPTED, !isCleanSession);
        if (okResp.variableHeader().connectReturnCode().byteValue() != MqttConnectReturnCode.CONNECTION_ACCEPTED.byteValue()) {
            LOG.info("CONNECT-none-accepted clientID: <{}>, ConnectionStatus: <{}>, client-address: <{}>, server-address: <{}>", new Object[]{clientId, okResp.variableHeader().connectReturnCode().byteValue(), client.remoteAddress(), client.localAddress()});
        }
        this.consumerManager.fireConsume(clientId);
        LOG.info("CONNECT successful, clientID: {}, client-address: <{}>, server-address: <{}>", new Object[]{clientId, client.remoteAddress(), client.localAddress()});
    }

    private MqttConnAckMessage sendAckToClient(Channel client, MqttConnectMessage connectMessage, MqttConnectReturnCode ackCode, boolean sessionPresent) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.CONNACK, false, connectMessage.fixedHeader().qosLevel(), false, 0);
        MqttConnAckMessage connAckMessage = (MqttConnAckMessage)MqttMessageFactory.newMessage((MqttFixedHeader)mqttFixedHeader, (Object)new MqttConnAckVariableHeader(ackCode, sessionPresent), null);
        client.writeAndFlush((Object)connAckMessage);
        return connAckMessage;
    }

    private boolean auth(String user, String password) {
        if (Strings.isNullOrEmpty((String)user) || Strings.isNullOrEmpty((String)password)) {
            return false;
        }
        Date now = Calendar.getInstance().getTime();
        AppToken appToken = this.nameService.getAppToken(user, password);
        return null != appToken && appToken.getEffectiveTime().before(now) && appToken.getExpirationTime().after(now);
    }

    private MqttConnectReturnCode checkAuth(MqttConnectMessage message) {
        boolean cleanSession = message.variableHeader().isCleanSession();
        String clientID = message.payload().clientIdentifier();
        boolean noId = Strings.isNullOrEmpty((String)clientID);
        if (noId) {
            LOG.debug("NULL clientID, cleanSession: {}", (Object)cleanSession);
            return MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("hasUserName: {}", (Object)message.variableHeader().hasUserName());
            LOG.debug("hasPassword: {}", (Object)message.variableHeader().hasPassword());
        }
        if (message.variableHeader().hasUserName() && message.variableHeader().hasPassword()) {
            String userName = message.payload().userName();
            String passWord = message.payload().password();
            if (LOG.isDebugEnabled()) {
                LOG.debug("CONN username: {}, password: {}", (Object)userName, (Object)passWord);
            }
            if (this.auth(userName, passWord)) {
                return MqttConnectReturnCode.CONNECTION_ACCEPTED;
            }
            return MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD;
        }
        return MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED;
    }

    private void initializeKeepAliveTimeout(Channel client, MqttConnectMessage msg, String clientId) {
        int keepAlive = msg.variableHeader().keepAliveTimeSeconds();
        NettyAttrManager.setAttrKeepAlive(client, keepAlive);
        NettyAttrManager.setAttrClientId(client, clientId);
        NettyAttrManager.setAttrCleanSession(client, msg.variableHeader().isCleanSession());
        int idleTime = Math.round((float)keepAlive * 1.5f);
        if (client.pipeline().names().contains("idleStateHandler")) {
            client.pipeline().remove("idleStateHandler");
        }
        client.pipeline().addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(idleTime, 0, 0));
    }

    private void storeWillMessage(String clientID, MqttConnectMessage msg) {
        if (msg.variableHeader().isWillFlag()) {
            MqttQoS willQos = MqttQoS.valueOf((int)msg.variableHeader().willQos());
            byte[] willPayload = msg.payload().willMessageInBytes();
            ByteBuffer bb = (ByteBuffer)ByteBuffer.allocate(willPayload.length).put(willPayload).flip();
            WillMessage will = new WillMessage(msg.payload().willTopic(), bb, msg.variableHeader().isWillRetain(), willQos);
            this.willStore.put(clientID, will);
            LOG.info("Latest will message stored for client: <{}>", (Object)clientID);
        }
    }

    private void addConnection(Channel client, MqttConnectMessage connectMessage, String clientID) {
        String userName = "";
        String passWord = "";
        if (connectMessage.variableHeader().hasUserName() && connectMessage.variableHeader().hasPassword()) {
            userName = connectMessage.payload().userName();
            passWord = connectMessage.payload().password();
        }
        MqttConnection connection = new MqttConnection(clientID, userName, passWord, connectMessage.variableHeader().isCleanSession(), connectMessage.variableHeader().version(), connectMessage.variableHeader().isWillRetain(), connectMessage.variableHeader().willQos(), connectMessage.variableHeader().isWillFlag(), connectMessage.variableHeader().keepAliveTimeSeconds(), client);
        connection.setAddress(IpUtil.toByte((InetSocketAddress)((InetSocketAddress)client.remoteAddress())));
        connection.setServerAddress(IpUtil.toByte((InetSocketAddress)((InetSocketAddress)client.localAddress())));
        MqttConnection existing = this.connectionManager.addConnection(connection);
        if (existing != null) {
            LOG.warn("\u91cd\u590dclientID\u7684connection\u8fde\u63a5: <{}>, \u9700\u8981\u65ad\u5f00\u6216\u8005\u91cd\u7f6e. \u65b0\u5efa\u7684client\u8fde\u63a5: <{}>", (Object)existing, (Object)connection);
            existing.getChannel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            this.connectionManager.removeConnection(existing);
            this.connectionManager.addConnection(connection);
        }
    }

    public void processDisconnect(Channel client) {
        String clientID = NettyAttrManager.getAttrClientId(client);
        this.cleanWillMessage(clientID);
        client.flush();
        client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        LOG.info("Disconnect successful, clientID: {}", (Object)clientID);
    }

    private void cleanWillMessage(String clientID) {
        this.willStore.remove(clientID);
    }

    public void processPublish(Channel client, MqttPublishMessage publishMessage) {
        String clientID = NettyAttrManager.getAttrClientId(client);
        if (Strings.isNullOrEmpty((String)clientID)) {
            LOG.error("ClientID is null or empty for publish, aborting... publishEvent message trace: <{}>", (Object)publishMessage.toString());
            client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            return;
        }
        try {
            String topic = publishMessage.variableHeader().topicName();
            MqttConnection connection = this.connectionManager.getConnection(clientID);
            if (connection == null) {
                LOG.error("Client connection is null for publish, clientID: {}", (Object)clientID);
                client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                return;
            }
            String application = connection.getApplication();
            if (Strings.isNullOrEmpty((String)application)) {
                LOG.error("Client application is null for publish, clientID: {}", (Object)clientID);
                client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                return;
            }
            Producer producer = this.producerManager.getProducer(clientID, application, topic);
            if (producer == null) {
                throw new Exception("MessageProducer instance null, please check producer create & start...");
            }
            this.messagePublisher.publishMessage(producer, client, publishMessage);
        }
        catch (Throwable th) {
            LOG.error("process Public Message Error!", th);
            client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    public void processPubAck(Channel client, MqttPubAckMessage pubAckMessage) {
        MqttMessageIdVariableHeader pubAckVariableMessage = pubAckMessage.variableHeader();
        short packageId = (short)pubAckVariableMessage.messageId();
        String clientId = NettyAttrManager.getAttrClientId(client);
        this.consumerManager.acknowledge(clientId, packageId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received PubAck packageID: {}" + packageId);
        }
    }

    public void processSubscribe(Channel client, MqttSubscribeMessage subscribeMessage) {
        ArrayList<Integer> resultCodes;
        block9: {
            resultCodes = new ArrayList<Integer>();
            String clientID = NettyAttrManager.getAttrClientId(client);
            if (this.connectionManager.isConnected(clientID)) {
                MqttConnection connection = this.connectionManager.getConnection(clientID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("\u5904\u7406subscribe\u6570\u636e\u5305, clientID: {}, cleanSession: {}", (Object)clientID, (Object)connection.isCleanSession());
                }
                List topicSubscribes = subscribeMessage.payload().topicSubscriptions();
                LOG.info("Subscribe topics: {}, clientID: {}", (Object)topicSubscribes, (Object)clientID);
                try {
                    if (null != topicSubscribes) {
                        Set<MqttSubscription> topicFilters = this.subscribe(topicSubscribes, clientID, connection.getClientGroupName(), resultCodes);
                        MqttSession session = this.sessionManager.getSession(clientID);
                        if (session != null) {
                            for (MqttSubscription subscription : topicFilters) {
                                session.addSubscription(subscription);
                            }
                        }
                    } else {
                        this.consumerManager.stopConsume(clientID);
                        this.sessionManager.removeSession(clientID);
                        connection.getChannel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                        this.connectionManager.removeConnection(connection);
                        client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                    }
                }
                catch (Exception e) {
                    LOG.error("subscribe is error!");
                    if (resultCodes.size() >= topicSubscribes.size()) break block9;
                    for (int minus = topicSubscribes.size() - resultCodes.size(); minus > 0; --minus) {
                        resultCodes.add(MqttQoS.FAILURE.value());
                    }
                }
            }
        }
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttSubAckMessage subAckMessage = (MqttSubAckMessage)MqttMessageFactory.newMessage((MqttFixedHeader)mqttFixedHeader, (Object)MqttMessageIdVariableHeader.from((int)subscribeMessage.variableHeader().messageId()), (Object)new MqttSubAckPayload(resultCodes));
        LOG.info("SUBSCRIBE successful, subscribe result: {}", resultCodes);
        client.writeAndFlush((Object)subAckMessage);
    }

    private Set<MqttSubscription> subscribe(List<MqttTopicSubscription> topicSubscribes, String clientID, String clientGroup, List<Integer> resultCodes) throws Exception {
        ArrayList<MqttSubscription> needSubsTopicFilters = new ArrayList<MqttSubscription>();
        for (MqttTopicSubscription mts : topicSubscribes) {
            if (!new TopicFilter(mts.topicName()).isValid()) {
                resultCodes.add(MqttQoS.FAILURE.value());
                LOG.warn("topic filter[{}] of clientID[{}] is invalid", (Object)mts.topicName(), (Object)clientID);
                continue;
            }
            needSubsTopicFilters.add(new MqttSubscription(clientID, new TopicFilter(mts.topicName()), mts.qualityOfService()));
            resultCodes.add(MqttQoS.AT_LEAST_ONCE.value());
        }
        LOG.info("Do subscribe topics: {}, clientGroup: {}", needSubsTopicFilters, (Object)clientGroup);
        return this.subscriptionManager.subscribes(clientGroup, needSubsTopicFilters);
    }

    public void processUnsubscribe(Channel client, MqttUnsubscribeMessage unSubscribeMessage) {
        String clientID = NettyAttrManager.getAttrClientId(client);
        int packageId = unSubscribeMessage.variableHeader().messageId();
        MqttQoS qoS = unSubscribeMessage.fixedHeader().qosLevel();
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5904\u7406unSubscribe\u6570\u636e\u5305, clientID: {}, packageId: {}, Qos: {}", new Object[]{clientID, packageId, qoS});
        }
        if (this.connectionManager.isConnected(clientID)) {
            MqttConnection connection = this.connectionManager.getConnection(clientID);
            List topicFilters = unSubscribeMessage.payload().topics();
            LOG.info("UnSubscribe topics: {}", (Object)topicFilters);
            try {
                if (topicFilters != null) {
                    Set<MqttSubscription> unSubcriptions = this.unSubscribe(topicFilters, clientID, connection.getClientGroupName());
                    MqttSession session = this.sessionManager.getSession(clientID);
                    if (session != null) {
                        for (MqttSubscription subscription : unSubcriptions) {
                            session.removeSubscription(subscription);
                        }
                    }
                } else {
                    this.consumerManager.stopConsume(clientID);
                    this.sessionManager.removeSession(clientID);
                    connection.getChannel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                    this.connectionManager.removeConnection(connection);
                    client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                }
            }
            catch (Exception e) {
                LOG.error("unSubscribe is error!");
            }
        }
        this.sendUnSubAck(client, packageId, qoS);
    }

    private void sendUnSubAck(Channel client, int packageID, MqttQoS qoS) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, qoS, false, 0);
        MqttMessage unSubAckMessage = MqttMessageFactory.newMessage((MqttFixedHeader)mqttFixedHeader, (Object)MqttMessageIdVariableHeader.from((int)packageID), null);
        LOG.info("UNSUBSCRIBE successful, packageID: {}", (Object)packageID);
        client.writeAndFlush((Object)unSubAckMessage);
    }

    private Set<MqttSubscription> unSubscribe(List<String> topicFilters, String clientID, String clientGroup) throws Exception {
        HashSet<MqttSubscription> needUnSubscriptions = new HashSet<MqttSubscription>(topicFilters.size());
        for (String topicFilter : topicFilters) {
            if (!TopicFilter.isValid(topicFilter)) {
                LOG.warn("topic filter[{}] of clientID[{}] is invalid", (Object)topicFilter, (Object)clientID);
                continue;
            }
            MqttSession session = this.sessionManager.getSession(clientID);
            if (session == null) continue;
            Set<MqttSubscription> subscriptions = session.listSubsciptions();
            for (MqttSubscription subscription : subscriptions) {
                if (!subscription.getTopicFilter().toString().equals(topicFilter) && !subscription.getTopicFilter().match(new TopicFilter(topicFilter))) continue;
                needUnSubscriptions.add(subscription);
            }
        }
        if (needUnSubscriptions.isEmpty()) {
            LOG.warn("topic filter for client: <{}> may be null, the topicFilters is <{}>", (Object)clientID, topicFilters);
            return new HashSet<MqttSubscription>();
        }
        this.subscriptionManager.unSubscribe(clientGroup, needUnSubscriptions);
        return needUnSubscriptions;
    }
}

