/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.handler;

import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.concurrent.ExecutorService;
import org.joyqueue.broker.mqtt.handler.ExecutorsProvider;
import org.joyqueue.broker.mqtt.handler.Handler;
import org.joyqueue.broker.mqtt.util.NettyAttrManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingReqHandler
extends Handler
implements ExecutorsProvider {
    private static final Logger logger = LoggerFactory.getLogger(PingReqHandler.class);

    @Override
    public void handleRequest(Channel client, MqttMessage message) throws Exception {
        String clientId = NettyAttrManager.getAttrClientId(client);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("PingRequest clientId:%s", clientId));
        }
        MqttFixedHeader pingHeader = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessage pingResp = new MqttMessage(pingHeader);
        client.writeAndFlush((Object)pingResp);
    }

    @Override
    public MqttMessageType type() {
        return MqttMessageType.PINGREQ;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.mqttContext.getExecutorServiceMap().get(PingReqHandler.class);
    }
}

