/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.handler;

import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import java.util.concurrent.ExecutorService;
import org.joyqueue.broker.mqtt.handler.ExecutorsProvider;
import org.joyqueue.broker.mqtt.handler.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishAckHandler
extends Handler
implements ExecutorsProvider {
    private static final Logger logger = LoggerFactory.getLogger(PublishAckHandler.class);

    @Override
    public void handleRequest(Channel client, MqttMessage message) throws Exception {
        MqttPubAckMessage pubAckMessage = (MqttPubAckMessage)message;
        this.mqttProtocolHandler.processPubAck(client, pubAckMessage);
    }

    @Override
    public MqttMessageType type() {
        return MqttMessageType.PUBACK;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.mqttContext.getExecutorServiceMap().get(PublishAckHandler.class);
    }
}

