/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import java.util.List;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.mqtt.handler.MqttHandlerDispatcher;
import org.joyqueue.broker.mqtt.network.AbstractMqttProtocolPipeline;
import org.joyqueue.broker.mqtt.transport.MqttCommandInvocation;
import org.joyqueue.broker.network.protocol.support.DefaultProtocolHandlerPipeline;
import org.joyqueue.network.handler.ConnectionHandler;
import org.joyqueue.network.protocol.Protocol;

public class MqttOverWebsocketProtocolHandlerPipeline
extends AbstractMqttProtocolPipeline {
    private static final String MQTT_SUBPROTOCOL_CSV_LIST = "mqtt, mqttv3.1, mqttv3.1.1";
    private Protocol protocol;
    private BrokerContext brokerContext;

    public MqttOverWebsocketProtocolHandlerPipeline(Protocol protocol, ChannelHandler channelHandler, BrokerContext brokerContext) {
        super(brokerContext);
        this.protocol = protocol;
        this.brokerContext = brokerContext;
        if (channelHandler instanceof DefaultProtocolHandlerPipeline) {
            DefaultProtocolHandlerPipeline defaultProtocolHandlerPipeline = (DefaultProtocolHandlerPipeline)channelHandler;
        }
    }

    protected void initChannel(Channel channel) throws Exception {
        channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/mqtt", MQTT_SUBPROTOCOL_CSV_LIST)}).addLast(new ChannelHandler[]{new WebSocketFrameToByteBufDecoder()}).addLast(new ChannelHandler[]{new ByteBufToWebSocketFrameEncoder()}).addLast(new ChannelHandler[]{new MqttDecoder(this.mqttContext.getMqttConfig().getMaxPayloadSize())}).addLast(new ChannelHandler[]{MqttEncoder.INSTANCE}).addLast(new ChannelHandler[]{new ConnectionHandler()}).addLast(new ChannelHandler[]{this.newMqttCommandInvocation()});
    }

    @Override
    protected MqttCommandInvocation newMqttCommandInvocation() {
        return new MqttCommandInvocation(this.newMqttHandlerDispatcher());
    }

    @Override
    protected MqttHandlerDispatcher newMqttHandlerDispatcher() {
        MqttHandlerDispatcher mqttHandlerDispatcher = new MqttHandlerDispatcher(this.protocol.createCommandHandlerFactory(), this.brokerContext, this.mqttContext);
        try {
            mqttHandlerDispatcher.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mqttHandlerDispatcher;
    }

    static class ByteBufToWebSocketFrameEncoder
    extends MessageToMessageEncoder<ByteBuf> {
        ByteBufToWebSocketFrameEncoder() {
        }

        protected void encode(ChannelHandlerContext chc, ByteBuf bb, List<Object> out) throws Exception {
            BinaryWebSocketFrame result = new BinaryWebSocketFrame();
            result.content().writeBytes(bb);
            out.add(result);
        }
    }

    static class WebSocketFrameToByteBufDecoder
    extends MessageToMessageDecoder<BinaryWebSocketFrame> {
        WebSocketFrameToByteBufDecoder() {
        }

        protected void decode(ChannelHandlerContext chc, BinaryWebSocketFrame frame, List<Object> out) throws Exception {
            ByteBuf bb = frame.content();
            bb.retain();
            out.add(bb);
        }
    }
}

