/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.mqtt.handler.MqttHandlerDispatcher;
import org.joyqueue.broker.mqtt.network.AbstractMqttProtocolPipeline;
import org.joyqueue.broker.mqtt.transport.MqttCommandInvocation;
import org.joyqueue.broker.network.protocol.support.DefaultProtocolHandlerPipeline;
import org.joyqueue.network.handler.ConnectionHandler;
import org.joyqueue.network.protocol.Protocol;

public class MqttProtocolHandlerPipeline
extends AbstractMqttProtocolPipeline {
    private Protocol protocol;
    private BrokerContext brokerContext;

    public MqttProtocolHandlerPipeline(Protocol protocol, ChannelHandler channelHandler, BrokerContext brokerContext) {
        super(brokerContext);
        this.protocol = protocol;
        this.brokerContext = brokerContext;
        if (channelHandler instanceof DefaultProtocolHandlerPipeline) {
            DefaultProtocolHandlerPipeline defaultProtocolHandlerPipeline = (DefaultProtocolHandlerPipeline)channelHandler;
        }
    }

    protected void initChannel(Channel channel) throws Exception {
        channel.pipeline().addLast(new ChannelHandler[]{new MqttDecoder(this.mqttContext.getMqttConfig().getMaxPayloadSize())}).addLast(new ChannelHandler[]{MqttEncoder.INSTANCE}).addLast(new ChannelHandler[]{new ConnectionHandler()}).addLast(new ChannelHandler[]{this.newMqttCommandInvocation()});
    }

    @Override
    protected MqttCommandInvocation newMqttCommandInvocation() {
        return new MqttCommandInvocation(this.newMqttHandlerDispatcher());
    }

    @Override
    protected MqttHandlerDispatcher newMqttHandlerDispatcher() {
        MqttHandlerDispatcher mqttHandlerDispatcher = new MqttHandlerDispatcher(this.protocol.createCommandHandlerFactory(), this.brokerContext, this.mqttContext);
        try {
            mqttHandlerDispatcher.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mqttHandlerDispatcher;
    }
}

