/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.AppendableCharSequence;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.mqtt.command.MqttHandlerFactory;
import org.joyqueue.broker.mqtt.network.MqttOverWebsocketProtocolHandlerPipeline;
import org.joyqueue.broker.mqtt.protocol.MqttHandlerRegister;
import org.joyqueue.network.protocol.ChannelHandlerProvider;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.protocol.ProtocolService;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttOverWebsocketProtocol
implements ProtocolService,
BrokerContextAware,
ChannelHandlerProvider {
    private static final Logger logger = LoggerFactory.getLogger(MqttOverWebsocketProtocol.class);
    private BrokerContext brokerContext;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    public boolean isSupport(ByteBuf buffer) {
        if (MqttOverWebsocketProtocol.isNativeMqtt(buffer)) {
            return false;
        }
        if (!MqttOverWebsocketProtocol.skipControlCharacters(buffer)) {
            return false;
        }
        int rIdx = buffer.readerIndex();
        LineParser lineParser = new LineParser(new AppendableCharSequence(65536), 4096);
        AppendableCharSequence line = lineParser.parse(buffer);
        String[] initialLine = MqttOverWebsocketProtocol.splitInitialLine(line);
        if (initialLine.length < 3) {
            return false;
        }
        Map<String, String> headers = this.readHeaders(buffer);
        buffer.readerIndex(rIdx);
        if (!headers.containsKey("Connection") && !headers.get("Connection").equals("Upgrade")) {
            return false;
        }
        if (!headers.containsKey("Upgrade") && !headers.get("Upgrade").equals("websocket")) {
            return false;
        }
        return headers.containsKey("Sec-WebSocket-Protocol") || headers.get("Sec-WebSocket-Protocol").equals("mqtt");
    }

    public CodecFactory createCodecFactory() {
        return null;
    }

    public CommandHandlerFactory createCommandHandlerFactory() {
        MqttHandlerFactory mqttHandlerFactory = new MqttHandlerFactory();
        return MqttHandlerRegister.register(mqttHandlerFactory);
    }

    public String type() {
        return "mqtt_over_websocket";
    }

    public ChannelHandler getChannelHandler(ChannelHandler channelHandler) {
        return new MqttOverWebsocketProtocolHandlerPipeline((Protocol)this, channelHandler, this.brokerContext);
    }

    private static boolean isNativeMqtt(ByteBuf byteBuf) {
        byteBuf.resetReaderIndex();
        if (byteBuf.readableBytes() < 2) {
            byteBuf.resetReaderIndex();
            return false;
        }
        byteBuf.resetReaderIndex();
        return true;
    }

    private static boolean skipControlCharacters(ByteBuf buffer) {
        boolean skiped = false;
        int wIdx = buffer.writerIndex();
        int rIdx = buffer.readerIndex();
        while (wIdx > rIdx) {
            short c;
            if (Character.isISOControl(c = buffer.getUnsignedByte(rIdx++)) || Character.isWhitespace(c)) continue;
            --rIdx;
            skiped = true;
            break;
        }
        buffer.readerIndex(rIdx);
        return skiped;
    }

    private static String[] splitInitialLine(AppendableCharSequence sb) {
        int aStart = MqttOverWebsocketProtocol.findNonWhitespace(sb, 0);
        int aEnd = MqttOverWebsocketProtocol.findWhitespace(sb, aStart);
        int bStart = MqttOverWebsocketProtocol.findNonWhitespace(sb, aEnd);
        int bEnd = MqttOverWebsocketProtocol.findWhitespace(sb, bStart);
        int cStart = MqttOverWebsocketProtocol.findNonWhitespace(sb, bEnd);
        int cEnd = MqttOverWebsocketProtocol.findEndOfString(sb);
        return new String[]{sb.subStringUnsafe(aStart, aEnd), sb.subStringUnsafe(bStart, bEnd), cStart < cEnd ? sb.subStringUnsafe(cStart, cEnd) : ""};
    }

    private static int findNonWhitespace(AppendableCharSequence sb, int offset) {
        for (int result = offset; result < sb.length(); ++result) {
            if (Character.isWhitespace(sb.charAtUnsafe(result))) continue;
            return result;
        }
        return sb.length();
    }

    private static int findWhitespace(AppendableCharSequence sb, int offset) {
        for (int result = offset; result < sb.length(); ++result) {
            if (!Character.isWhitespace(sb.charAtUnsafe(result))) continue;
            return result;
        }
        return sb.length();
    }

    private static int findEndOfString(AppendableCharSequence sb) {
        for (int result = sb.length() - 1; result > 0; --result) {
            if (Character.isWhitespace(sb.charAtUnsafe(result))) continue;
            return result + 1;
        }
        return 0;
    }

    private Map<String, String> readHeaders(ByteBuf buffer) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CharSequence name = null;
        CharSequence value = null;
        HeaderParser headerParser = new HeaderParser(new AppendableCharSequence(65536), 8192);
        AppendableCharSequence line = headerParser.parse(buffer);
        if (line == null) {
            return headers;
        }
        if (line.length() > 0) {
            do {
                char firstChar = line.charAt(0);
                if (name != null && (firstChar == ' ' || firstChar == '\t')) {
                    String trimmedLine = line.toString().trim();
                    StringBuilder buf = new StringBuilder(value.length() + trimmedLine.length() + 1);
                    buf.append(value).append(' ').append(trimmedLine);
                    value = buf.toString();
                } else {
                    int colonEnd;
                    int nameStart;
                    char ch;
                    int nameEnd;
                    if (name != null) {
                        headers.put(name.toString(), value.toString());
                    }
                    int length = line.length();
                    for (nameEnd = nameStart = MqttOverWebsocketProtocol.findNonWhitespace(line, 0); nameEnd < length && (ch = line.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
                    }
                    for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
                        if (line.charAt(colonEnd) != ':') continue;
                        ++colonEnd;
                        break;
                    }
                    name = line.subStringUnsafe(nameStart, nameEnd);
                    int valueStart = MqttOverWebsocketProtocol.findNonWhitespace(line, colonEnd);
                    if (valueStart == length) {
                        value = "";
                    } else {
                        int valueEnd = MqttOverWebsocketProtocol.findEndOfString(line);
                        value = line.subStringUnsafe(valueStart, valueEnd);
                    }
                }
                line = headerParser.parse(buffer);
                if (line != null) continue;
                return null;
            } while (line.length() > 0);
        }
        if (name != null) {
            headers.put(name.toString(), value.toString());
        }
        return headers;
    }

    private static final class LineParser
    extends HeaderParser {
        LineParser(AppendableCharSequence seq, int maxLength) {
            super(seq, maxLength);
        }

        @Override
        public AppendableCharSequence parse(ByteBuf buffer) {
            this.reset();
            return super.parse(buffer);
        }

        @Override
        protected TooLongFrameException newException(int maxLength) {
            return new TooLongFrameException("An HTTP line is larger than " + maxLength + " bytes.");
        }
    }

    private static class HeaderParser
    implements ByteProcessor {
        private final AppendableCharSequence seq;
        private final int maxLength;
        private int size;

        HeaderParser(AppendableCharSequence seq, int maxLength) {
            this.seq = seq;
            this.maxLength = maxLength;
        }

        public AppendableCharSequence parse(ByteBuf buffer) {
            int oldSize = this.size;
            this.seq.reset();
            int i = buffer.forEachByte((ByteProcessor)this);
            if (i == -1) {
                this.size = oldSize;
                return null;
            }
            buffer.readerIndex(i + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        public boolean process(byte value) throws Exception {
            char nextByte = (char)(value & 0xFF);
            if (nextByte == '\r') {
                return true;
            }
            if (nextByte == '\n') {
                return false;
            }
            if (++this.size > this.maxLength) {
                throw this.newException(this.maxLength);
            }
            this.seq.append(nextByte);
            return true;
        }

        protected TooLongFrameException newException(int maxLength) {
            return new TooLongFrameException("HTTP header is larger than " + maxLength + " bytes.");
        }
    }
}

