/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.util.CharsetUtil;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.mqtt.command.MqttHandlerFactory;
import org.joyqueue.broker.mqtt.network.MqttProtocolHandlerPipeline;
import org.joyqueue.broker.mqtt.protocol.MqttHandlerRegister;
import org.joyqueue.network.protocol.ChannelHandlerProvider;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.protocol.ProtocolService;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttProtocol
implements ProtocolService,
BrokerContextAware,
ChannelHandlerProvider {
    private static final Logger logger = LoggerFactory.getLogger(MqttProtocol.class);
    private BrokerContext brokerContext;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    public boolean isSupport(ByteBuf buffer) {
        return this.decodeProtocol(buffer);
    }

    private boolean decodeProtocol(ByteBuf buffer) {
        short digit;
        short b1 = buffer.readUnsignedByte();
        int messageType = b1 >> 4;
        boolean dupFlag = (b1 & 8) == 8;
        int qosLevel = (b1 & 6) >> 1;
        boolean retain = (b1 & 1) != 0;
        int remainingLength = 0;
        int multiplier = 1;
        int loops = 0;
        do {
            digit = buffer.readUnsignedByte();
            remainingLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0 && ++loops < 4);
        if (loops == 4 && (digit & 0x80) != 0) {
            return false;
        }
        if (buffer.readerIndex() >= buffer.writerIndex()) {
            return false;
        }
        short msbSize = buffer.readUnsignedByte();
        short lsbSize = buffer.readUnsignedByte();
        int result = msbSize << 8 | lsbSize;
        String protocolName = buffer.toString(buffer.readerIndex(), result, CharsetUtil.UTF_8);
        return protocolName.equals("MQTT");
    }

    public CodecFactory createCodecFactory() {
        return null;
    }

    public CommandHandlerFactory createCommandHandlerFactory() {
        MqttHandlerFactory mqttHandlerFactory = new MqttHandlerFactory();
        return MqttHandlerRegister.register(mqttHandlerFactory);
    }

    public String type() {
        return "mqtt";
    }

    public ChannelHandler getChannelHandler(ChannelHandler channelHandler) {
        return new MqttProtocolHandlerPipeline((Protocol)this, channelHandler, this.brokerContext);
    }
}

