/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.publish;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.mqtt.cluster.MqttConnectionManager;
import org.joyqueue.broker.mqtt.connection.MqttConnection;
import org.joyqueue.broker.mqtt.session.MqttSession;
import org.joyqueue.broker.mqtt.util.MqttMessageSerializer;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.session.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MessagePublisher.class);
    private Produce produce;
    private Consume consume;
    private MqttConnectionManager connectionManager;

    public MessagePublisher(BrokerContext brokerContext, MqttConnectionManager connectionManager) {
        this.produce = brokerContext.getProduce();
        this.consume = brokerContext.getConsume();
        this.connectionManager = connectionManager;
    }

    public void publishMessage(Producer producer, Channel client, MqttPublishMessage publishMessage) throws JoyQueueException {
        MqttQoS qos = publishMessage.fixedHeader().qosLevel();
        int packageID = publishMessage.variableHeader().packetId();
        this.produce.putMessageAsync(producer, Collections.singletonList(MqttMessageSerializer.convertToBrokerMsg(client, publishMessage)), QosLevel.RECEIVE, event -> this.processPublishResult(client, qos, packageID));
    }

    private void processPublishResult(Channel client, MqttQoS qos, int packageID) {
        switch (qos) {
            case AT_MOST_ONCE: {
                break;
            }
            case AT_LEAST_ONCE: {
                this.sendPubAck(client, packageID);
                break;
            }
            case EXACTLY_ONCE: {
                break;
            }
            case FAILURE: {
                LOG.info("Received failure qos message, ignore...");
            }
        }
    }

    private void sendPubAck(Channel client, Integer packageID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u53d1\u9001PubAck\u6d88\u606f\u7ed9\u5ba2\u6237\u7aef");
        }
        try {
            MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
            MqttMessage pubAckMessage = MqttMessageFactory.newMessage((MqttFixedHeader)mqttFixedHeader, (Object)MqttMessageIdVariableHeader.from((int)packageID), null);
            client.writeAndFlush((Object)pubAckMessage);
        }
        catch (Throwable th) {
            LOG.error("Send pubAck error!", th);
            client.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    public void publish2Subscriber(String name, String clientID, MqttSession session, Consumer consumer, int qos) throws Exception {
        PullResult result = this.consume.getMessage(consumer, 1, 120000);
        String topicName = result.getTopic();
        List buffers = result.getBuffers();
        if (buffers != null && buffers.size() > 0) {
            MqttConnection connection;
            Channel channel;
            BrokerMessage brokerMessage = Serializer.readBrokerMessage((ByteBuffer)((ByteBuffer)buffers.get(0)));
            MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.valueOf((int)MqttMessageSerializer.getLowerQos(MqttMessageSerializer.readExtension(brokerMessage), qos)), false, 0);
            int packageId = session.getMessageAcknowledgedZone().acquireAcknowledgedPosition(brokerMessage);
            MqttPublishMessage publishMsg = (MqttPublishMessage)MqttMessageFactory.newMessage((MqttFixedHeader)mqttFixedHeader, (Object)new MqttPublishVariableHeader(topicName, packageId), (Object)Unpooled.wrappedBuffer((byte[])brokerMessage.getByteBody()));
            boolean isActive = this.connectionManager.isConnected(clientID);
            if (isActive && (channel = (connection = this.connectionManager.getConnection(clientID)).getChannel()).isActive() && channel.isOpen()) {
                channel.writeAndFlush((Object)publishMsg).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    if (channelFuture.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\u63a8\u9001\u6d88\u606f\u6210\u529f: {}", (Object)publishMsg);
                        }
                    } else {
                        LOG.error("publish message error, thread: <{}>, clientID: <{}>, message: <{}>, cause: <{}>", new Object[]{name, clientID, brokerMessage, channelFuture.cause()});
                        throw new Exception(channelFuture.cause());
                    }
                }));
            }
        }
    }
}

