/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joyqueue.broker.mqtt.subscriptions.MqttSubscription;
import org.joyqueue.message.BrokerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSession
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MqttSession.class);
    private static final long serialVersionUID = -1L;
    private final String clientID;
    private final Set<MqttSubscription> subscriptions = new HashSet<MqttSubscription>();
    private boolean cleanSession;
    private final MessageAcknowledgedZone messageAcknowledgedZone = new MessageAcknowledgedZone();

    public MqttSession(String clientID, boolean cleanSession) {
        this.clientID = clientID;
        this.cleanSession = cleanSession;
    }

    public void addSubscription(MqttSubscription newSubscription) {
        if (newSubscription == null) {
            LOG.error("Add null subscription for session");
            return;
        }
        this.subscriptions.add(newSubscription);
    }

    public void removeSubscription(MqttSubscription subscription) {
        LOG.debug("Remove subscription topic filter: {} for clientID: {}", (Object)subscription.getTopicFilter(), (Object)this.clientID);
        this.subscriptions.remove(subscription);
    }

    public Set<MqttSubscription> listSubsciptions() {
        return this.subscriptions;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public MessageAcknowledgedZone getMessageAcknowledgedZone() {
        return this.messageAcknowledgedZone;
    }

    public String toString() {
        return "MqttSession{clientID='" + this.clientID + '\'' + ", subscriptions=" + this.subscriptions + ", cleanSession=" + this.cleanSession + '}';
    }

    public class MessageAcknowledgedZone {
        final Map<Integer, BrokerMessage> acknowledgedMap = Collections.synchronizedMap(new HashMap());

        public BrokerMessage acquireAcknowledgedMessage(Integer packageId) {
            BrokerMessage brokerMessage = this.acknowledgedMap.remove(packageId);
            if (brokerMessage == null) {
                LOG.error("Can't find the message for client: <{}> publish ack packageId: <{}>", (Object)MqttSession.this.clientID, (Object)packageId);
                throw new RuntimeException("Can't find the session message for client <" + MqttSession.this.clientID + ">");
            }
            return brokerMessage;
        }

        public int acquireAcknowledgedPosition(BrokerMessage brokerMessage) {
            int maxId = this.acknowledgedMap.keySet().isEmpty() ? 0 : Collections.max(this.acknowledgedMap.keySet());
            int nextPacketId = (maxId + 1) % 65535;
            this.acknowledgedMap.put(nextPacketId, brokerMessage);
            return nextPacketId;
        }

        public int zoneSize() {
            return this.acknowledgedMap.size();
        }

        public String toString() {
            return "MessageAcknowledgedZone{acknowledgedMap.size()=" + this.acknowledgedMap.size() + '}';
        }
    }
}

