/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.subscriptions;

import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import org.joyqueue.broker.mqtt.subscriptions.TopicFilter;

public class MqttSubscription
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final MqttQoS requestedQos;
    private final String clientId;
    private final TopicFilter topicFilter;

    public MqttSubscription(String clientId, TopicFilter topicFilter, MqttQoS requestedQos) {
        this.clientId = clientId;
        this.topicFilter = topicFilter;
        this.requestedQos = requestedQos;
    }

    public MqttSubscription(MqttSubscription source) {
        this.clientId = source.clientId;
        this.topicFilter = source.topicFilter;
        this.requestedQos = source.requestedQos;
    }

    public MqttQoS getRequestedQos() {
        return this.requestedQos;
    }

    public String getClientId() {
        return this.clientId;
    }

    public TopicFilter getTopicFilter() {
        return this.topicFilter;
    }

    public int hashCode() {
        int result = this.clientId != null ? this.clientId.hashCode() : 0;
        result = 31 * result + (this.topicFilter != null ? this.topicFilter.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttSubscription that = (MqttSubscription)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        return !(this.topicFilter == null ? that.topicFilter != null : !this.topicFilter.equals(that.topicFilter));
    }

    public String toString() {
        return "MqttSubscription{requestedQos=" + this.requestedQos + ", clientId='" + this.clientId + '\'' + ", topicFilter=" + this.topicFilter + '}';
    }
}

