/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.transport;

import com.google.common.base.Strings;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import org.joyqueue.broker.mqtt.cluster.MqttConnectionManager;
import org.joyqueue.broker.mqtt.cluster.MqttConsumerManager;
import org.joyqueue.broker.mqtt.cluster.MqttSessionManager;
import org.joyqueue.broker.mqtt.connection.MqttConnection;
import org.joyqueue.broker.mqtt.handler.ExecutorsProvider;
import org.joyqueue.broker.mqtt.handler.Handler;
import org.joyqueue.broker.mqtt.handler.HandlerExecutor;
import org.joyqueue.broker.mqtt.handler.MqttHandlerDispatcher;
import org.joyqueue.broker.mqtt.util.NettyAttrManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MqttCommandInvocation
extends SimpleChannelInboundHandler<Object> {
    private final Logger LOG = LoggerFactory.getLogger(MqttCommandInvocation.class);
    private MqttHandlerDispatcher mqttHandlerDispatcher;
    private MqttConnectionManager connectionManager;
    private MqttSessionManager sessionManager;
    private MqttConsumerManager consumerManager;

    public MqttCommandInvocation(MqttHandlerDispatcher mqttHandlerDispatcher) {
        this.mqttHandlerDispatcher = mqttHandlerDispatcher;
        this.connectionManager = mqttHandlerDispatcher.getMqttProtocolHandler().getConnectionManager();
        this.sessionManager = mqttHandlerDispatcher.getMqttProtocolHandler().getSessionManager();
        this.consumerManager = mqttHandlerDispatcher.getMqttProtocolHandler().getConsumerManager();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (ctx.channel().isActive()) {
                MqttMessage message;
                if (msg instanceof MqttMessage && (message = (MqttMessage)msg).decoderResult().isSuccess()) {
                    Handler handler = this.mqttHandlerDispatcher.getHandler(message.fixedHeader().messageType());
                    HandlerExecutor executor = new HandlerExecutor(handler, ctx, message);
                    if (handler instanceof ExecutorsProvider) {
                        ((ExecutorsProvider)((Object)handler)).getExecutorService().submit(executor);
                    } else {
                        executor.execute();
                    }
                }
            } else {
                this.LOG.error("The channel is not active!" + ctx.channel());
            }
        }
        catch (Throwable th) {
            this.LOG.error("MqttCommandInvocation got exception: ", th);
            ctx.fireExceptionCaught(th);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        String clientId = NettyAttrManager.getAttrClientId(ctx.channel());
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state().equals((Object)IdleState.READER_IDLE)) {
                this.LOG.info("READER_IDLE: {}, start close channel...", (Object)clientId);
                ctx.fireChannelInactive();
                ctx.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            } else if (event.state().equals((Object)IdleState.WRITER_IDLE)) {
                this.LOG.info("WRITER_IDLE: {}, start close channel...", (Object)clientId);
            } else if (event.state().equals((Object)IdleState.ALL_IDLE)) {
                this.LOG.info("ALL_IDLE: {}, start close channel...", (Object)clientId);
                ctx.fireChannelInactive();
                ctx.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientId = NettyAttrManager.getAttrClientId(ctx.channel());
        if (!Strings.isNullOrEmpty((String)clientId)) {
            MqttConnection connection = this.connectionManager.getConnection(clientId);
            if (connection == null) {
                ctx.channel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                return;
            }
            if (!ctx.channel().equals(connection.getChannel())) {
                ctx.channel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                return;
            }
            this.consumerManager.stopConsume(clientId);
            this.sessionManager.removeSession(clientId);
            this.connectionManager.removeConnection(connection);
        }
        ctx.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        String clientId = NettyAttrManager.getAttrClientId(ctx.channel());
        this.LOG.info("Channel Writable Changed, clientID: {}", (Object)clientId);
        ctx.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String clientId = NettyAttrManager.getAttrClientId(ctx.channel());
        if (!Strings.isNullOrEmpty((String)clientId)) {
            this.LOG.info("Exception got clientID: {}, cause: {}, {}", new Object[]{clientId, cause.getCause(), cause.getMessage()});
            this.consumerManager.stopConsume(clientId);
            this.sessionManager.removeSession(clientId);
            MqttConnection connection = this.connectionManager.getConnection(clientId);
            if (connection != null) {
                connection.getChannel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                this.connectionManager.removeConnection(connection);
                return;
            }
            ctx.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }
}

