/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.client;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.BootStrap;
import io.journalkeeper.core.api.AdminClient;
import io.journalkeeper.core.api.QueryConsistency;
import io.journalkeeper.core.api.RaftClient;
import io.journalkeeper.sql.client.EventWatcherAdapter;
import io.journalkeeper.sql.client.SQLEventListener;
import io.journalkeeper.sql.client.domain.Codes;
import io.journalkeeper.sql.client.domain.OperationTypes;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.ResultSet;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.client.exception.SQLClientException;
import io.journalkeeper.sql.exception.SQLException;
import io.journalkeeper.utils.event.EventWatcher;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLClient {
    protected static final Logger logger = LoggerFactory.getLogger(SQLClient.class);
    private final Serializer<WriteRequest> writeRequestSerializer;
    private final Serializer<WriteResponse> writeResponseSerializer;
    private final Serializer<ReadRequest> readRequestSerializer;
    private final Serializer<ReadResponse> readResponseSerializer;
    private List<URI> servers;
    private Properties config;
    private BootStrap bootStrap;
    private RaftClient client;
    private final QueryConsistency queryConsistency;

    public SQLClient(List<URI> servers, Properties config, BootStrap bootStrap, Serializer<WriteRequest> writeRequestSerializer, Serializer<WriteResponse> writeResponseSerializer, Serializer<ReadRequest> readRequestSerializer, Serializer<ReadResponse> readResponseSerializer) {
        this.writeRequestSerializer = writeRequestSerializer;
        this.writeResponseSerializer = writeResponseSerializer;
        this.readRequestSerializer = readRequestSerializer;
        this.readResponseSerializer = readResponseSerializer;
        this.queryConsistency = QueryConsistency.valueOf((String)config.getProperty("sql.consistency", "STRICT"));
        this.servers = servers;
        this.config = config;
        this.bootStrap = bootStrap;
        this.client = bootStrap.getClient();
    }

    public void waitClusterReady(long maxWaitMs) throws TimeoutException, InterruptedException {
        this.client.waitForClusterReady(maxWaitMs);
    }

    public CompletableFuture<ResultSet> query(String sql, List<Object> params) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new SQLException("sql not blank");
        }
        try {
            return ((CompletableFuture)this.doQuery(new ReadRequest(OperationTypes.QUERY.getType(), sql, params)).exceptionally(cause -> {
                throw this.convertException((Throwable)cause);
            })).thenApply(ReadResponse::getResultSet);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public CompletableFuture<Object> insert(String sql, List<Object> params) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new SQLException("sql not blank");
        }
        try {
            return ((CompletableFuture)this.doUpdate(new WriteRequest(OperationTypes.INSERT.getType(), sql, params)).exceptionally(cause -> {
                throw this.convertException((Throwable)cause);
            })).thenApply(response -> response.getResult());
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public CompletableFuture<Object> update(String sql, List<Object> params) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new SQLException("sql not blank");
        }
        try {
            return ((CompletableFuture)this.doUpdate(new WriteRequest(OperationTypes.UPDATE.getType(), sql, params)).exceptionally(cause -> {
                throw this.convertException((Throwable)cause);
            })).thenApply(response -> Integer.valueOf(response.getResult().toString()));
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public CompletableFuture<Object> delete(String sql, List<Object> params) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new SQLException("sql not blank");
        }
        try {
            return ((CompletableFuture)this.doUpdate(new WriteRequest(OperationTypes.DELETE.getType(), sql, params)).exceptionally(cause -> {
                throw this.convertException((Throwable)cause);
            })).thenApply(response -> Integer.valueOf(response.getResult().toString()));
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public CompletableFuture<List<Object>> batch(List<String> sqlList, List<List<Object>> paramList) {
        if (sqlList == null || sqlList.isEmpty()) {
            throw new SQLException("sqlList not empty");
        }
        try {
            return ((CompletableFuture)this.doUpdate(new WriteRequest(OperationTypes.BATCH.getType(), sqlList, paramList)).exceptionally(cause -> {
                throw this.convertException((Throwable)cause);
            })).thenApply(response -> response.getResultList());
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public AdminClient getAdminClient() {
        return this.bootStrap.getAdminClient();
    }

    public Properties getConfig() {
        return this.config;
    }

    public void watch(SQLEventListener listener) {
        this.client.watch((EventWatcher)new EventWatcherAdapter(listener));
    }

    public void unwatch(SQLEventListener listener) {
        this.client.unWatch((EventWatcher)new EventWatcherAdapter(listener));
    }

    public void watch(byte[] key, SQLEventListener listener) {
        this.client.watch((EventWatcher)new EventWatcherAdapter(key, listener));
    }

    public void unwatch(byte[] key, SQLEventListener listener) {
        this.client.unWatch((EventWatcher)new EventWatcherAdapter(key, listener));
    }

    public void stop() {
        this.client.stop();
    }

    protected SQLClientException convertException(Throwable cause) {
        if (cause instanceof SQLClientException) {
            SQLClientException sqlClientException = (SQLClientException)cause;
            if (StringUtils.isBlank((CharSequence)sqlClientException.getMessage())) {
                return sqlClientException;
            }
            return new SQLClientException(sqlClientException.getMessage());
        }
        if (cause instanceof ExecutionException) {
            return new SQLClientException(cause.getCause());
        }
        throw new SQLClientException(cause);
    }

    protected CompletableFuture<WriteResponse> doUpdate(WriteRequest request) {
        return ((CompletableFuture)((CompletableFuture)this.client.update(this.writeRequestSerializer.serialize((Object)request)).exceptionally(t -> {
            throw new SQLClientException(t.getCause());
        })).thenApply(arg_0 -> this.writeResponseSerializer.parse(arg_0))).thenApply(response -> {
            if (response.getCode() != Codes.SUCCESS.getCode()) {
                throw new SQLClientException(String.format("code: %s, msg: %s", String.valueOf((Object)Codes.valueOf(response.getCode())), response.getMsg()));
            }
            return response;
        });
    }

    protected CompletableFuture<ReadResponse> doQuery(ReadRequest request) {
        return ((CompletableFuture)((CompletableFuture)this.client.query(this.readRequestSerializer.serialize((Object)request), this.queryConsistency).exceptionally(t -> {
            throw new SQLClientException(t.getCause());
        })).thenApply(arg_0 -> this.readResponseSerializer.parse(arg_0))).thenApply(response -> {
            if (response.getCode() != Codes.SUCCESS.getCode()) {
                throw new SQLClientException(String.format("code: %s, msg: %s", String.valueOf((Object)Codes.valueOf(response.getCode())), response.getMsg()));
            }
            return response;
        });
    }
}

