/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.client;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.BootStrap;
import io.journalkeeper.sql.client.SQLClient;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.serializer.KryoSerializer;
import java.net.URI;
import java.util.List;
import java.util.Properties;

public class SQLClientAccessPoint {
    private Properties config;
    private Serializer<WriteRequest> writeRequestSerializer;
    private Serializer<WriteResponse> writeResponseSerializer;
    private Serializer<ReadRequest> readRequestSerializer;
    private Serializer<ReadResponse> readResponseSerializer;

    public SQLClientAccessPoint(Properties config) {
        this(config, new KryoSerializer<WriteRequest>(WriteRequest.class), new KryoSerializer<WriteResponse>(WriteResponse.class), new KryoSerializer<ReadRequest>(ReadRequest.class), new KryoSerializer<ReadResponse>(ReadResponse.class));
    }

    public SQLClientAccessPoint(Properties config, Serializer<WriteRequest> writeRequestSerializer, Serializer<WriteResponse> writeResponseSerializer, Serializer<ReadRequest> readRequestSerializer, Serializer<ReadResponse> readResponseSerializer) {
        this.config = config;
        this.writeRequestSerializer = writeRequestSerializer;
        this.writeResponseSerializer = writeResponseSerializer;
        this.readRequestSerializer = readRequestSerializer;
        this.readResponseSerializer = readResponseSerializer;
    }

    public SQLClient createClient(List<URI> servers) {
        BootStrap bootStrap = new BootStrap(servers, this.config);
        return new SQLClient(servers, this.config, bootStrap, this.writeRequestSerializer, this.writeResponseSerializer, this.readRequestSerializer, this.readResponseSerializer);
    }
}

