/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.client.support;

import io.journalkeeper.sql.client.BatchSQLOperator;
import io.journalkeeper.sql.client.SQLClient;
import io.journalkeeper.sql.client.helper.ParamHelper;
import io.journalkeeper.sql.exception.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class DefaultBatchSQLOperator
implements BatchSQLOperator {
    private SQLClient client;
    private int timeout;
    private List<String> sqlList = new LinkedList<String>();
    private List<List<Object>> paramList = new LinkedList<List<Object>>();

    public DefaultBatchSQLOperator(SQLClient client, int timeout) {
        this.client = client;
        this.timeout = timeout;
    }

    @Override
    public void insert(String sql, Object ... params) {
        this.sqlList.add(sql);
        this.paramList.add(ParamHelper.toList(params));
    }

    @Override
    public void update(String sql, Object ... params) {
        this.sqlList.add(sql);
        this.paramList.add(ParamHelper.toList(params));
    }

    @Override
    public void delete(String sql, Object ... params) {
        this.sqlList.add(sql);
        this.paramList.add(ParamHelper.toList(params));
    }

    @Override
    public List<Object> commit() {
        if (this.sqlList == null || this.sqlList.isEmpty()) {
            return null;
        }
        try {
            return this.client.batch(this.sqlList, this.paramList).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    protected SQLException convertException(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof ExecutionException) {
            return this.convertException(((ExecutionException)e).getCause());
        }
        return new SQLException(e);
    }
}

