/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.client.support;

import io.journalkeeper.sql.client.BatchSQLOperator;
import io.journalkeeper.sql.client.SQLClient;
import io.journalkeeper.sql.client.SQLOperator;
import io.journalkeeper.sql.client.domain.ResultSet;
import io.journalkeeper.sql.client.helper.ParamHelper;
import io.journalkeeper.sql.client.support.DefaultBatchSQLOperator;
import io.journalkeeper.sql.exception.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class DefaultSQLOperator
implements SQLOperator {
    private SQLClient client;
    private int timeout;

    public DefaultSQLOperator(SQLClient client) {
        this.client = client;
        this.timeout = Integer.valueOf(client.getConfig().getProperty("sql.timeout", String.valueOf(10000)));
    }

    @Override
    public Object insert(String sql, Object ... params) {
        try {
            return this.client.insert(sql, ParamHelper.toList(params)).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int update(String sql, Object ... params) {
        try {
            return (Integer)this.client.update(sql, ParamHelper.toList(params)).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int delete(String sql, Object ... params) {
        try {
            return (Integer)this.client.delete(sql, ParamHelper.toList(params)).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public ResultSet query(String sql, Object ... params) {
        try {
            return this.client.query(sql, ParamHelper.toList(params)).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BatchSQLOperator beginBatch() {
        return new DefaultBatchSQLOperator(this.client, this.timeout);
    }

    protected SQLException convertException(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof ExecutionException) {
            return this.convertException(((ExecutionException)e).getCause());
        }
        return new SQLException(e);
    }
}

