/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import io.journalkeeper.base.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.ArrayUtils;

public class KryoSerializer<T>
implements Serializer<T> {
    private static final int BUFFER_SIZE = 5120;
    private final KryoPool kryoPool;
    private Class<T> type;

    public KryoSerializer(Class<T> type) {
        this.type = type;
        this.kryoPool = new KryoPool.Builder(() -> {
            Kryo kryo = new Kryo();
            if (type != null) {
                kryo.register(type);
            }
            return kryo;
        }).build();
    }

    public byte[] serialize(Object entry) {
        if (entry == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        Kryo kryo = this.kryoPool.borrow();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5120);
        Output output = new Output((OutputStream)outputStream);
        if (this.type == null) {
            kryo.writeClassAndObject(output, entry);
        } else {
            kryo.writeObject(output, entry);
        }
        this.kryoPool.release(kryo);
        output.flush();
        byte[] result = outputStream.toByteArray();
        output.close();
        return result;
    }

    public T parse(byte[] bytes) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        Kryo kryo = this.kryoPool.borrow();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Input input = new Input((InputStream)inputStream);
        Object result = kryo.readObject(input, this.type);
        this.kryoPool.release(kryo);
        input.close();
        return (T)result;
    }
}

