/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.server;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.BootStrap;
import io.journalkeeper.core.api.AdminClient;
import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.sql.client.SQLClient;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.exception.SQLException;
import io.journalkeeper.sql.state.SQLStateFactory;
import io.journalkeeper.utils.state.StateServer;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServer
implements StateServer {
    protected static final Logger logger = LoggerFactory.getLogger(SQLServer.class);
    private final Serializer<WriteRequest> writeRequestSerializer;
    private final Serializer<WriteResponse> writeResponseSerializer;
    private final Serializer<ReadRequest> readRequestSerializer;
    private final Serializer<ReadResponse> readResponseSerializer;
    private URI current;
    private List<URI> servers;
    private RaftServer.Roll role;
    private Properties config;
    private BootStrap bootStrap;
    private volatile SQLClient client;

    public SQLServer(URI current, List<URI> servers, Properties config, RaftServer.Roll role, SQLStateFactory stateFactory) {
        this.writeRequestSerializer = stateFactory.getWriteRequestSerializer();
        this.writeResponseSerializer = stateFactory.getWriteResponseSerializer();
        this.readRequestSerializer = stateFactory.getReadRequestSerializer();
        this.readResponseSerializer = stateFactory.getReadResponseSerializer();
        this.current = current;
        this.servers = servers;
        this.role = role;
        this.config = config;
        this.bootStrap = new BootStrap(role, (StateFactory)stateFactory, config);
    }

    public SQLServer(List<URI> servers, Properties config, SQLStateFactory stateFactory) {
        this.servers = servers;
        this.config = config;
        this.writeRequestSerializer = stateFactory.getWriteRequestSerializer();
        this.writeResponseSerializer = stateFactory.getWriteResponseSerializer();
        this.readRequestSerializer = stateFactory.getReadRequestSerializer();
        this.readResponseSerializer = stateFactory.getReadResponseSerializer();
        this.bootStrap = new BootStrap(servers, config);
    }

    public URI getCurrent() {
        return this.current;
    }

    public List<URI> getServers() {
        return this.servers;
    }

    public RaftServer.Roll getRole() {
        return this.role;
    }

    public boolean waitClusterReady(long timeout, TimeUnit unit) {
        timeout = unit.toMillis(timeout);
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < timeout || timeout <= 0L) {
            try {
                this.bootStrap.getClient().waitForClusterReady(1000L);
                return true;
            }
            catch (TimeoutException timeoutException) {
                logger.info("wait for cluster ready, current: {}, servers: {}", (Object)this.current, this.servers);
            }
        }
        throw new SQLException(new TimeoutException());
    }

    public URI getLeader() {
        try {
            return ((ClusterConfiguration)this.bootStrap.getAdminClient().getClusterConfiguration().get()).getLeader();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLClient getClient() {
        if (this.client == null) {
            SQLServer sQLServer = this;
            synchronized (sQLServer) {
                if (this.client == null) {
                    this.client = new SQLClient(this.servers, this.config, this.bootStrap, this.writeRequestSerializer, this.writeResponseSerializer, this.readRequestSerializer, this.readResponseSerializer);
                }
            }
        }
        return this.client;
    }

    public void start() {
        try {
            this.bootStrap.getServer().start();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void tryStart() {
        try {
            RaftServer server = this.bootStrap.getServer();
            if (!server.isInitialized()) {
                server.init(this.current, this.servers);
            }
            server.recover();
            server.start();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void recover() {
        try {
            this.bootStrap.getServer().recover();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public boolean isInitialized() {
        return this.bootStrap.getServer().isInitialized();
    }

    public void init() {
        try {
            this.bootStrap.getServer().init(this.current, this.servers);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void stop() {
        this.bootStrap.shutdown();
    }

    public StateServer.ServerState serverState() {
        return this.bootStrap.getServer().serverState();
    }

    public AdminClient getAdminClient() {
        return this.bootStrap.getAdminClient();
    }
}

