/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.server;

import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.serializer.KryoSerializer;
import io.journalkeeper.sql.server.SQLServer;
import io.journalkeeper.sql.state.SQLStateFactory;
import java.net.URI;
import java.util.List;
import java.util.Properties;

public class SQLServerAccessPoint {
    private Properties config;
    private SQLStateFactory stateFactory;

    public SQLServerAccessPoint(Properties config) {
        this(config, new SQLStateFactory(new KryoSerializer<WriteRequest>(WriteRequest.class), new KryoSerializer<WriteResponse>(WriteResponse.class), new KryoSerializer<ReadRequest>(ReadRequest.class), new KryoSerializer<ReadResponse>(ReadResponse.class)));
    }

    public SQLServerAccessPoint(Properties config, SQLStateFactory stateFactory) {
        this.config = config;
        this.stateFactory = stateFactory;
    }

    public SQLServer createServer(URI current, List<URI> servers, RaftServer.Roll role) {
        return new SQLServer(current, servers, this.config, role, this.stateFactory);
    }

    public SQLServer createRemoteServer(URI current, List<URI> servers) {
        return new SQLServer(servers, this.config, this.stateFactory);
    }
}

