/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state;

import io.journalkeeper.sql.state.SQLExecutorFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class SQLExecutorManager {
    private static final Map<String, SQLExecutorFactory> executors = SQLExecutorManager.loadExecutors();

    protected static Map<String, SQLExecutorFactory> loadExecutors() {
        HashMap<String, SQLExecutorFactory> result = new HashMap<String, SQLExecutorFactory>();
        ServiceLoader<SQLExecutorFactory> factoryLoader = ServiceLoader.load(SQLExecutorFactory.class);
        for (SQLExecutorFactory factory : factoryLoader) {
            result.put(factory.type(), factory);
        }
        return result;
    }

    public static SQLExecutorFactory getExecutor(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return executors.values().iterator().next();
        }
        return executors.get(type);
    }
}

