/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.api.RaftJournal;
import io.journalkeeper.core.api.State;
import io.journalkeeper.core.api.StateResult;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.exception.SQLException;
import io.journalkeeper.sql.state.SQLExecutor;
import io.journalkeeper.sql.state.SQLExecutorManager;
import io.journalkeeper.sql.state.handler.SQLStateHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLState
implements State {
    private static final Logger logger = LoggerFactory.getLogger(SQLState.class);
    private final Serializer<WriteRequest> writeRequestSerializer;
    private final Serializer<WriteResponse> writeResponseSerializer;
    private final Serializer<ReadRequest> readRequestSerializer;
    private final Serializer<ReadResponse> readResponseSerializer;
    private Path path;
    private Properties properties;
    private SQLExecutor executor;
    private SQLStateHandler handler;

    public SQLState(Serializer<WriteRequest> writeRequestSerializer, Serializer<WriteResponse> writeResponseSerializer, Serializer<ReadRequest> readRequestSerializer, Serializer<ReadResponse> readResponseSerializer) {
        this.writeRequestSerializer = writeRequestSerializer;
        this.writeResponseSerializer = writeResponseSerializer;
        this.readRequestSerializer = readRequestSerializer;
        this.readResponseSerializer = readResponseSerializer;
    }

    public void recover(Path path, Properties properties) throws IOException {
        this.path = path;
        this.executor = SQLExecutorManager.getExecutor(properties.getProperty("sql.executor.type")).create(path, properties);
        if (this.executor == null) {
            throw new IllegalArgumentException("executor not exist");
        }
        this.properties = properties;
        this.handler = new SQLStateHandler(properties, this.executor);
        this.initExecutor(properties);
    }

    protected void initExecutor(Properties properties) {
        String initFile = properties.getProperty("sql.init.file");
        if (StringUtils.isBlank((CharSequence)initFile)) {
            return;
        }
        try {
            InputStream initFileStream = SQLState.class.getResourceAsStream(initFile);
            if (initFileStream == null) {
                logger.warn("init file not exist, file: {}", (Object)initFile);
                return;
            }
            String sql = IOUtils.toString((InputStream)initFileStream, (Charset)Charset.forName("UTF-8"));
            this.executor.update(sql, null);
        }
        catch (Exception e) {
            logger.error("init exception", (Throwable)e);
            throw new SQLException(e);
        }
    }

    public StateResult execute(byte[] requestEntry, int partition, long index, int batchSize, RaftJournal raftJournal) {
        WriteRequest request = (WriteRequest)this.writeRequestSerializer.parse(requestEntry);
        WriteResponse response = this.handler.handleWrite(request);
        StateResult result = new StateResult(this.writeResponseSerializer.serialize((Object)response));
        result.getEventData().put("type", String.valueOf(request.getType()));
        result.getEventData().put("sql", String.valueOf(request.getSql()));
        result.getEventData().put("batchSql", String.valueOf(request.getSqlList()));
        result.getEventData().put("params", String.valueOf(request.getParams()));
        return result;
    }

    public byte[] query(byte[] request, RaftJournal raftJournal) {
        return this.readResponseSerializer.serialize((Object)this.handler.handleRead((ReadRequest)this.readRequestSerializer.parse(request)));
    }

    public void close() {
        this.executor.close();
    }
}

