/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.api.State;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.state.SQLState;

public class SQLStateFactory
implements StateFactory {
    private final Serializer<WriteRequest> writeRequestSerializer;
    private final Serializer<WriteResponse> writeResponseSerializer;
    private final Serializer<ReadRequest> readRequestSerializer;
    private final Serializer<ReadResponse> readResponseSerializer;

    public SQLStateFactory(Serializer<WriteRequest> writeRequestSerializer, Serializer<WriteResponse> writeResponseSerializer, Serializer<ReadRequest> readRequestSerializer, Serializer<ReadResponse> readResponseSerializer) {
        this.writeRequestSerializer = writeRequestSerializer;
        this.writeResponseSerializer = writeResponseSerializer;
        this.readRequestSerializer = readRequestSerializer;
        this.readResponseSerializer = readResponseSerializer;
    }

    public State createState() {
        return new SQLState(this.writeRequestSerializer, this.writeResponseSerializer, this.readRequestSerializer, this.readResponseSerializer);
    }

    public Serializer<WriteRequest> getWriteRequestSerializer() {
        return this.writeRequestSerializer;
    }

    public Serializer<WriteResponse> getWriteResponseSerializer() {
        return this.writeResponseSerializer;
    }

    public Serializer<ReadRequest> getReadRequestSerializer() {
        return this.readRequestSerializer;
    }

    public Serializer<ReadResponse> getReadResponseSerializer() {
        return this.readResponseSerializer;
    }
}

