/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.handler;

import io.journalkeeper.metric.JMetric;
import io.journalkeeper.metric.JMetricFactory;
import io.journalkeeper.metric.JMetricFactoryManager;
import io.journalkeeper.sql.client.domain.Codes;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.state.SQLExecutor;
import io.journalkeeper.sql.state.handler.SQLStateReadHandler;
import io.journalkeeper.sql.state.handler.SQLStateWriteHandler;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStateHandler {
    protected static final Logger logger = LoggerFactory.getLogger(SQLStateHandler.class);
    private final ConcurrentMap<String, JMetric> metricMap = new ConcurrentHashMap<String, JMetric>();
    private Properties properties;
    private SQLExecutor sqlExecutor;
    private SQLStateReadHandler readHandler;
    private SQLStateWriteHandler writeHandler;
    private JMetricFactory metricFactory;

    public SQLStateHandler(Properties properties, SQLExecutor sqlExecutor) {
        this.properties = properties;
        this.sqlExecutor = sqlExecutor;
        this.readHandler = new SQLStateReadHandler(properties, sqlExecutor);
        this.writeHandler = new SQLStateWriteHandler(properties, sqlExecutor);
        this.metricFactory = JMetricFactoryManager.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteResponse handleWrite(WriteRequest request) {
        LinkedList<JMetric> metricList = new LinkedList<JMetric>();
        if (request.getSqlList() == null) {
            metricList.add(this.getMetric(request.getSql()));
        } else {
            for (String sql : request.getSqlList()) {
                metricList.add(this.getMetric(sql));
            }
        }
        for (JMetric metric : metricList) {
            metric.start();
        }
        try {
            WriteResponse writeResponse = this.writeHandler.handle(request);
            return writeResponse;
        }
        catch (Throwable e) {
            logger.error("sql write exception, request: {}", (Object)request, (Object)e);
            WriteResponse writeResponse = new WriteResponse(Codes.ERROR.getCode(), e.toString());
            return writeResponse;
        }
        finally {
            for (JMetric metric : metricList) {
                metric.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadResponse handleRead(ReadRequest request) {
        JMetric metric = this.getMetric(request.getSql());
        metric.start();
        try {
            ReadResponse readResponse = this.readHandler.handle(request);
            return readResponse;
        }
        catch (Throwable e) {
            logger.error("sql read exception, request: {}", (Object)request, (Object)e);
            ReadResponse readResponse = new ReadResponse(Codes.ERROR.getCode(), e.toString());
            return readResponse;
        }
        finally {
            metric.end();
        }
    }

    protected JMetric getMetric(String sql) {
        JMetric metric = (JMetric)this.metricMap.get(sql);
        if (metric != null) {
            return metric;
        }
        metric = this.metricFactory.create(sql);
        JMetric oldMetric = this.metricMap.putIfAbsent(sql, metric);
        if (oldMetric != null) {
            return oldMetric;
        }
        return metric;
    }
}

