/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.handler;

import io.journalkeeper.sql.client.domain.Codes;
import io.journalkeeper.sql.client.domain.OperationTypes;
import io.journalkeeper.sql.client.domain.ReadRequest;
import io.journalkeeper.sql.client.domain.ReadResponse;
import io.journalkeeper.sql.client.domain.ResultSet;
import io.journalkeeper.sql.state.SQLExecutor;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStateReadHandler {
    protected static final Logger logger = LoggerFactory.getLogger(SQLStateReadHandler.class);
    private Properties properties;
    private SQLExecutor sqlExecutor;

    public SQLStateReadHandler(Properties properties, SQLExecutor sqlExecutor) {
        this.properties = properties;
        this.sqlExecutor = sqlExecutor;
    }

    public ReadResponse handle(ReadRequest request) {
        OperationTypes type = OperationTypes.valueOf(request.getType());
        switch (type) {
            case QUERY: {
                return this.doQuery(request);
            }
        }
        throw new UnsupportedOperationException(String.format("unsupported type, %s", new Object[]{type}));
    }

    protected ReadResponse doQuery(ReadRequest request) {
        ResultSet result = this.sqlExecutor.query(request.getSql(), request.getParams());
        return new ReadResponse(Codes.SUCCESS.getCode(), result);
    }
}

