/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.handler;

import io.journalkeeper.sql.client.domain.Codes;
import io.journalkeeper.sql.client.domain.OperationTypes;
import io.journalkeeper.sql.client.domain.WriteRequest;
import io.journalkeeper.sql.client.domain.WriteResponse;
import io.journalkeeper.sql.state.SQLExecutor;
import io.journalkeeper.sql.state.SQLTransactionExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStateWriteHandler {
    protected static final Logger logger = LoggerFactory.getLogger(SQLStateWriteHandler.class);
    private Properties properties;
    private SQLExecutor sqlExecutor;

    public SQLStateWriteHandler(Properties properties, SQLExecutor sqlExecutor) {
        this.properties = properties;
        this.sqlExecutor = sqlExecutor;
    }

    public WriteResponse handle(WriteRequest request) {
        OperationTypes type = OperationTypes.valueOf(request.getType());
        switch (type) {
            case INSERT: {
                return this.doInsert(request);
            }
            case UPDATE: {
                return this.doUpdate(request);
            }
            case DELETE: {
                return this.doDelete(request);
            }
            case BATCH: {
                return this.doBatch(request);
            }
        }
        throw new UnsupportedOperationException(String.format("unsupported type, %s", new Object[]{type}));
    }

    protected WriteResponse doInsert(WriteRequest request) {
        String result = this.sqlExecutor.insert(request.getSql(), request.getParams());
        return new WriteResponse(Codes.SUCCESS.getCode(), result);
    }

    protected WriteResponse doUpdate(WriteRequest request) {
        int result = this.sqlExecutor.update(request.getSql(), request.getParams());
        return new WriteResponse(Codes.SUCCESS.getCode(), result);
    }

    protected WriteResponse doDelete(WriteRequest request) {
        int result = this.sqlExecutor.delete(request.getSql(), request.getParams());
        return new WriteResponse(Codes.SUCCESS.getCode(), result);
    }

    protected WriteResponse doBatch(WriteRequest request) {
        SQLTransactionExecutor transaction = this.sqlExecutor.beginTransaction();
        try {
            ArrayList<Object> resultList = new ArrayList<Object>(request.getSqlList().size());
            for (int i = 0; i < request.getSqlList().size(); ++i) {
                String sql = request.getSqlList().get(i);
                List<Object> params = request.getParamList().get(i);
                Integer result = transaction.update(sql, params);
                resultList.add(result);
            }
            transaction.commit();
            return new WriteResponse(Codes.SUCCESS.getCode(), resultList);
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }
}

