/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.jdbc;

import io.journalkeeper.sql.state.jdbc.DataSourceFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class DataSourceFactoryManager {
    private static final Map<String, DataSourceFactory> executors = DataSourceFactoryManager.loadFactories();

    protected static Map<String, DataSourceFactory> loadFactories() {
        HashMap<String, DataSourceFactory> result = new HashMap<String, DataSourceFactory>();
        ServiceLoader<DataSourceFactory> factoryLoader = ServiceLoader.load(DataSourceFactory.class);
        for (DataSourceFactory factory : factoryLoader) {
            result.put(factory.type(), factory);
        }
        return result;
    }

    public static DataSourceFactory getFactory(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return executors.values().iterator().next();
        }
        return executors.get(type);
    }
}

