/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.jdbc;

import io.journalkeeper.sql.client.domain.ResultSet;
import io.journalkeeper.sql.exception.SQLException;
import io.journalkeeper.sql.state.SQLExecutor;
import io.journalkeeper.sql.state.SQLTransactionExecutor;
import io.journalkeeper.sql.state.jdbc.DataSourceFactory;
import io.journalkeeper.sql.state.jdbc.JDBCExecutor;
import io.journalkeeper.sql.state.jdbc.JDBCSQLTransactionExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

public class JDBCSQLExecutor
implements SQLExecutor {
    private DataSourceFactory dataSourceFactory;
    private JDBCExecutor executor;
    private DataSource dataSource;

    public JDBCSQLExecutor(Path path, Properties properties, DataSourceFactory dataSourceFactory, JDBCExecutor executor) {
        this.dataSourceFactory = dataSourceFactory;
        this.executor = executor;
        this.dataSource = dataSourceFactory.createDataSource(path, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String insert(String sql, List<Object> params) {
        Connection connection = this.getConnection();
        try {
            String string = this.executor.insert(connection, sql, params);
            return string;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String sql, List<Object> params) {
        Connection connection = this.getConnection();
        try {
            int n = this.executor.update(connection, sql, params);
            return n;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(String sql, List<Object> params) {
        Connection connection = this.getConnection();
        try {
            int n = this.executor.delete(connection, sql, params);
            return n;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet query(String sql, List<Object> params) {
        Connection connection = this.getConnection();
        try {
            ResultSet resultSet = this.executor.query(connection, sql, params);
            return resultSet;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public SQLTransactionExecutor beginTransaction() {
        Connection connection = this.getTransactionConnection();
        JDBCSQLTransactionExecutor transactionExecutor = new JDBCSQLTransactionExecutor(connection, this.executor);
        return transactionExecutor;
    }

    @Override
    public void close() {
        if (this.dataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)this.dataSource)).close();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    protected Connection getTransactionConnection() {
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            return connection;
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    protected Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    protected void releaseConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException();
        }
    }
}

