/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.jdbc;

import io.journalkeeper.sql.state.SQLExecutor;
import io.journalkeeper.sql.state.SQLExecutorFactory;
import io.journalkeeper.sql.state.jdbc.DataSourceFactory;
import io.journalkeeper.sql.state.jdbc.DataSourceFactoryManager;
import io.journalkeeper.sql.state.jdbc.JDBCExecutor;
import io.journalkeeper.sql.state.jdbc.JDBCSQLExecutor;
import java.nio.file.Path;
import java.util.Properties;

public class JDBCSQLExecutorFactory
implements SQLExecutorFactory {
    @Override
    public SQLExecutor create(Path path, Properties properties) {
        DataSourceFactory dataSourceFactory = DataSourceFactoryManager.getFactory(properties.getProperty("sql.datasource.type"));
        if (dataSourceFactory == null) {
            throw new IllegalArgumentException("datasource not exist");
        }
        JDBCExecutor jdbcExecutor = new JDBCExecutor();
        return new JDBCSQLExecutor(path, properties, dataSourceFactory, jdbcExecutor);
    }

    @Override
    public String type() {
        return "jdbc";
    }
}

