/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.jdbc;

import io.journalkeeper.sql.client.domain.ResultSet;
import io.journalkeeper.sql.exception.SQLException;
import io.journalkeeper.sql.state.SQLTransactionExecutor;
import io.journalkeeper.sql.state.jdbc.JDBCExecutor;
import java.sql.Connection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSQLTransactionExecutor
implements SQLTransactionExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(JDBCSQLTransactionExecutor.class);
    private Connection connection;
    private JDBCExecutor executor;

    public JDBCSQLTransactionExecutor(Connection connection, JDBCExecutor executor) {
        this.connection = connection;
        this.executor = executor;
    }

    @Override
    public String insert(String sql, List<Object> params) {
        return this.executor.insert(this.connection, sql, params);
    }

    @Override
    public int update(String sql, List<Object> params) {
        return this.executor.update(this.connection, sql, params);
    }

    @Override
    public int delete(String sql, List<Object> params) {
        return this.executor.delete(this.connection, sql, params);
    }

    @Override
    public ResultSet query(String sql, List<Object> params) {
        return this.executor.query(this.connection, sql, params);
    }

    @Override
    public boolean commit() {
        try {
            this.connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (java.sql.SQLException e) {
            logger.error("commit transaction exception", (Throwable)e);
            throw new SQLException(e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (java.sql.SQLException e) {
                logger.error("close transaction exception", (Throwable)e);
            }
        }
    }

    @Override
    public boolean rollback() {
        try {
            this.connection.rollback();
            boolean bl = true;
            return bl;
        }
        catch (java.sql.SQLException e) {
            logger.error("rollback transaction exception", (Throwable)e);
            throw new SQLException(e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (java.sql.SQLException e) {
                logger.error("close transaction exception", (Throwable)e);
            }
        }
    }
}

