/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.state.jdbc.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBUtils {
    public static String insert(Connection connection, String sql, List<Object> params) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
        DBUtils.fillParams(preparedStatement, params);
        preparedStatement.execute();
        ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
        if (generatedKeys.next()) {
            return generatedKeys.getString(1);
        }
        return null;
    }

    public static int update(Connection connection, String sql, List<Object> params) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        DBUtils.fillParams(preparedStatement, params);
        return preparedStatement.executeUpdate();
    }

    public static int delete(Connection connection, String sql, List<Object> params) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        DBUtils.fillParams(preparedStatement, params);
        return preparedStatement.executeUpdate();
    }

    public static List<Map<String, String>> query(Connection connection, String sql, List<Object> params) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        DBUtils.fillParams(preparedStatement, params);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData metaData = resultSet.getMetaData();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        while (resultSet.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                row.put(metaData.getColumnName(i + 1), resultSet.getString(i + 1));
            }
            result.add(row);
        }
        return result;
    }

    protected static void fillParams(PreparedStatement preparedStatement, List<Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            preparedStatement.setObject(i + 1, params.get(i));
        }
    }
}

