/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc;

import io.journalkeeper.rpc.StatusCode;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;

public abstract class BaseResponse {
    private StatusCode statusCode = StatusCode.SUCCESS;
    private String error = null;

    public BaseResponse() {
    }

    public BaseResponse(Throwable throwable) {
        if (null != throwable) {
            this.statusCode = StatusCode.EXCEPTION;
            this.setException(throwable);
        }
    }

    public BaseResponse(StatusCode statusCode) {
        this.setStatusCode(statusCode);
    }

    private void setException(Throwable throwable) {
        try {
            throw throwable instanceof CompletionException ? throwable.getCause() : throwable;
        }
        catch (TimeoutException e) {
            this.setStatusCode(StatusCode.TIMEOUT);
        }
        catch (IllegalStateException e) {
            this.setStatusCode(StatusCode.RETRY_LATER);
        }
        catch (Throwable t) {
            this.onSetException(t);
        }
    }

    protected void onSetException(Throwable throwable) {
        this.error = throwable.getMessage();
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
        this.error = statusCode.getMessage(new Object[0]);
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean success() {
        return this.statusCode == StatusCode.SUCCESS;
    }

    public String errorString() {
        return String.format("StatusCode: (%d)%s, ErrorMessage: %s", this.statusCode.getCode(), this.statusCode.getMessage(new Object[0]), this.error);
    }
}

