/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc;

import java.util.HashMap;
import java.util.Map;

public enum StatusCode {
    SUCCESS(0, "SUCCESS"),
    UNKNOWN_ERROR(1, "UNKNOWN_ERROR"),
    EXCEPTION(2, "EXCEPTION"),
    TRANSPORT_FAILED(3, "TRANSPORT_FAILED"),
    SERVER_BUSY(4, "SERVER_BUSY"),
    TIMEOUT(5, "TIMEOUT"),
    RETRY_LATER(6, "RETRY_LATER"),
    SERVER_NOT_FOUND(7, "SERVER_NOT_FOUND"),
    NOT_LEADER(100, "NOT_LEADER"),
    PULL_WATCH_ID_NOT_EXISTS(101, "PULL_WATCH_ID_NOT_EXISTS"),
    INDEX_UNDERFLOW(201, "INDEX_UNDERFLOW"),
    INDEX_OVERFLOW(202, "INDEX_OVERFLOW");

    private static Map<Integer, StatusCode> codes;
    private int code;
    private String message;

    private StatusCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static StatusCode valueOf(int code) {
        return codes.get(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage(Object ... args) {
        if (args.length < 1) {
            return this.message;
        }
        return String.format(this.message, args);
    }

    static {
        codes = new HashMap<Integer, StatusCode>();
        for (StatusCode jmqCode : StatusCode.values()) {
            codes.put(jmqCode.code, jmqCode);
        }
    }
}

