/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.client;

import io.journalkeeper.exceptions.IndexOverflowException;
import io.journalkeeper.exceptions.IndexUnderflowException;
import io.journalkeeper.rpc.LeaderResponse;
import io.journalkeeper.rpc.StatusCode;

public class QueryStateResponse
extends LeaderResponse {
    private final byte[] result;
    private final long lastApplied;

    public QueryStateResponse(Throwable t) {
        this(null, -1L, t);
    }

    public QueryStateResponse(byte[] result, long lastApplied) {
        this(result, lastApplied, null);
    }

    public QueryStateResponse(byte[] result) {
        this(result, -1L, null);
    }

    private QueryStateResponse(byte[] result, long lastApplied, Throwable t) {
        super(t);
        this.result = result;
        this.lastApplied = lastApplied;
    }

    public byte[] getResult() {
        return this.result;
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    @Override
    protected void onSetException(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (IndexOverflowException e) {
            this.setStatusCode(StatusCode.INDEX_OVERFLOW);
        }
        catch (IndexUnderflowException e) {
            this.setStatusCode(StatusCode.INDEX_UNDERFLOW);
        }
        catch (Throwable t) {
            super.onSetException(throwable);
        }
    }
}

