/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.client;

import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.UpdateRequest;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class UpdateClusterStateRequest {
    private final UUID transactionId;
    private final List<UpdateRequest> requests;
    private final boolean includeHeader;
    private final ResponseConfig responseConfig;

    public UpdateClusterStateRequest(byte[] entry, int partition, int batchSize) {
        this(entry, partition, batchSize, false, ResponseConfig.REPLICATION);
    }

    public UpdateClusterStateRequest(byte[] entry, int partition, int batchSize, boolean includeHeader, ResponseConfig responseConfig) {
        this(null, entry, partition, batchSize, includeHeader, responseConfig);
    }

    public UpdateClusterStateRequest(UUID transactionId, byte[] entry, int partition, int batchSize, boolean includeHeader) {
        this(transactionId, entry, partition, batchSize, includeHeader, ResponseConfig.REPLICATION);
    }

    public UpdateClusterStateRequest(UUID transactionId, byte[] entry, int partition, int batchSize, boolean includeHeader, ResponseConfig responseConfig) {
        this(transactionId, Collections.singletonList(new UpdateRequest(entry, partition, batchSize)), includeHeader, responseConfig);
    }

    public UpdateClusterStateRequest(UUID transactionId, List<UpdateRequest> requests, boolean includeHeader, ResponseConfig responseConfig) {
        this.transactionId = transactionId;
        this.requests = requests;
        this.includeHeader = includeHeader;
        this.responseConfig = responseConfig;
    }

    public UpdateClusterStateRequest(List<UpdateRequest> requests, boolean includeHeader, ResponseConfig responseConfig) {
        this(null, requests, includeHeader, responseConfig);
    }

    public UpdateClusterStateRequest(List<UpdateRequest> requests) {
        this(null, requests, false, ResponseConfig.REPLICATION);
    }

    public UpdateClusterStateRequest(UpdateRequest request) {
        this(null, Collections.singletonList(request), false, ResponseConfig.REPLICATION);
    }

    public UpdateClusterStateRequest(UUID transactionId, List<UpdateRequest> requests, boolean includeHeader) {
        this(transactionId, requests, includeHeader, ResponseConfig.REPLICATION);
    }

    public List<UpdateRequest> getRequests() {
        return this.requests;
    }

    public ResponseConfig getResponseConfig() {
        return this.responseConfig;
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public UUID getTransactionId() {
        return this.transactionId;
    }
}

