/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.server;

import io.journalkeeper.exceptions.IndexOverflowException;
import io.journalkeeper.exceptions.IndexUnderflowException;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.StatusCode;
import java.util.List;

public class GetServerEntriesResponse
extends BaseResponse {
    private final List<byte[]> entries;
    private final long minIndex;
    private final long lastApplied;

    public GetServerEntriesResponse(Throwable exception, long minIndex, long lastApplied) {
        this(exception, null, minIndex, lastApplied);
    }

    public GetServerEntriesResponse(Throwable exception) {
        this(exception, null, -1L, -1L);
    }

    public GetServerEntriesResponse(List<byte[]> entries, long minIndex, long lastApplied) {
        this(null, entries, minIndex, lastApplied);
    }

    private GetServerEntriesResponse(Throwable exception, List<byte[]> entries, long minIndex, long lastApplied) {
        super(exception);
        this.entries = entries;
        this.minIndex = minIndex;
        this.lastApplied = lastApplied;
    }

    public List<byte[]> getEntries() {
        return this.entries;
    }

    public long getMinIndex() {
        return this.minIndex;
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    @Override
    public void onSetException(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (IndexOverflowException e) {
            this.setStatusCode(StatusCode.INDEX_OVERFLOW);
        }
        catch (IndexUnderflowException e) {
            this.setStatusCode(StatusCode.INDEX_UNDERFLOW);
        }
        catch (Throwable t) {
            super.onSetException(throwable);
        }
    }
}

