/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.server;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;

public class InstallSnapshotRequest {
    private final int term;
    private final URI leaderId;
    private final long lastIncludedIndex;
    private final int lastIncludedTerm;
    private final int offset;
    private final byte[] data;
    private final boolean done;

    public InstallSnapshotRequest(int term, URI leaderId, long lastIncludedIndex, int lastIncludedTerm, int offset, byte[] data, boolean done) {
        this.term = term;
        this.leaderId = leaderId;
        this.lastIncludedIndex = lastIncludedIndex;
        this.lastIncludedTerm = lastIncludedTerm;
        this.offset = offset;
        this.data = data;
        this.done = done;
    }

    public int getTerm() {
        return this.term;
    }

    public URI getLeaderId() {
        return this.leaderId;
    }

    public long getLastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    public int getLastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isDone() {
        return this.done;
    }

    public String toString() {
        return "InstallSnapshotRequest{term=" + this.term + ", leaderId=" + this.leaderId + ", lastIncludedIndex=" + this.lastIncludedIndex + ", lastIncludedTerm=" + this.lastIncludedTerm + ", offset=" + this.offset + ", done=" + this.done + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallSnapshotRequest request = (InstallSnapshotRequest)o;
        return this.term == request.term && this.lastIncludedIndex == request.lastIncludedIndex && this.lastIncludedTerm == request.lastIncludedTerm && this.offset == request.offset && this.done == request.done && this.leaderId.equals(request.leaderId) && Arrays.equals(this.data, request.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.term, this.leaderId, this.lastIncludedIndex, this.lastIncludedTerm, this.offset, this.done);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

