/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper;

import io.journalkeeper.sql.client.BatchSQLOperator;
import io.journalkeeper.sql.client.SQLOperator;

public class BatchOperationContext {
    private static final ThreadLocal<BatchSQLOperator> batchOperatorThreadLocal = new ThreadLocal();
    private static SQLOperator sqlOperator;

    public static void init(SQLOperator sqlOperator) {
        if (BatchOperationContext.sqlOperator != null) {
            return;
        }
        BatchOperationContext.sqlOperator = sqlOperator;
    }

    public static void begin() {
        BatchSQLOperator batchSQLOperator = sqlOperator.beginBatch();
        batchOperatorThreadLocal.set(batchSQLOperator);
    }

    public static void commit() {
        BatchSQLOperator batchSQLOperator = batchOperatorThreadLocal.get();
        if (batchSQLOperator == null) {
            throw new UnsupportedOperationException("batch not exist");
        }
        batchSQLOperator.commit();
        batchOperatorThreadLocal.remove();
    }

    public static void rollback() {
        batchOperatorThreadLocal.remove();
    }

    public static void close() {
        BatchSQLOperator batchSQLOperator = batchOperatorThreadLocal.get();
        if (batchSQLOperator == null) {
            throw new UnsupportedOperationException("batch not exist");
        }
        batchOperatorThreadLocal.remove();
    }

    public static BatchSQLOperator getBatchSQLOperator() {
        return batchOperatorThreadLocal.get();
    }
}

