/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper;

import com.google.common.collect.Lists;
import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.sql.client.SQLClient;
import io.journalkeeper.sql.client.SQLClientAccessPoint;
import io.journalkeeper.sql.client.SQLOperator;
import io.journalkeeper.sql.client.support.DefaultSQLOperator;
import io.journalkeeper.sql.server.SQLServer;
import io.journalkeeper.sql.server.SQLServerAccessPoint;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.nsr.InternalServiceProvider;
import org.joyqueue.nsr.NsrPlugins;
import org.joyqueue.nsr.journalkeeper.BatchOperationContext;
import org.joyqueue.nsr.journalkeeper.JournalkeeperInternalServiceManager;
import org.joyqueue.nsr.journalkeeper.config.JournalkeeperConfig;
import org.joyqueue.nsr.journalkeeper.config.JournalkeeperConfigKey;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalkeeperInternalServiceProvider
extends Service
implements InternalServiceProvider,
PropertySupplierAware {
    protected static final Logger logger = LoggerFactory.getLogger(JournalkeeperInternalServiceProvider.class);
    private PropertySupplier propertySupplier;
    private JournalkeeperConfig config;
    private PointTracer tracer;
    private SQLServer sqlServer;
    private SQLClient sqlClient;
    private SQLOperator sqlOperator;
    private JournalkeeperInternalServiceManager journalkeeperInternalServiceManager;

    public void setSupplier(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.config = new JournalkeeperConfig(propertySupplier);
    }

    protected Properties convertProperties(JournalkeeperConfig config, List<Property> properties) {
        Properties result = new Properties();
        for (Property property : properties) {
            if (!property.getKey().startsWith(JournalkeeperConfigKey.PREFIX.getName())) continue;
            result.setProperty(property.getKey().substring(JournalkeeperConfigKey.PREFIX.getName().length() + 1), property.getString());
        }
        result.setProperty("snapshot_interval_sec", String.valueOf(config.getSnapshotIntervalSec()));
        result.setProperty("journal_retention_min", String.valueOf(config.getJournalRetentionMin()));
        result.setProperty("rpc_timeout_ms", String.valueOf(config.getRpcTimeout()));
        result.setProperty("flush_interval_ms", String.valueOf(config.getFlushInterval()));
        result.setProperty("working_dir", String.valueOf(config.getWorkingDir()));
        result.setProperty("get_state_batch_size", String.valueOf(config.getStateBatchSize()));
        result.setProperty("enable_metric", String.valueOf(config.getMetricEnable()));
        result.setProperty("print_metric_interval_sec", String.valueOf(config.getMetricPrintInterval()));
        result.setProperty("sql.timeout", String.valueOf(config.getExecuteTimeout()));
        result.setProperty("sql.init.file", config.getInitFile());
        return result;
    }

    protected void validate() throws Exception {
        this.tracer = (PointTracer)NsrPlugins.TRACERERVICE.get(PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE));
    }

    protected void doStart() throws Exception {
        Properties journalkeeperProperties = this.convertProperties(this.config, this.propertySupplier.getProperties());
        URI currentNode = URI.create(String.format("journalkeeper://%s:%s", this.config.getLocal(), this.config.getPort()));
        List<URI> nodes = JournalkeeperInternalServiceProvider.parseNodeUris(currentNode, this.config.getNodes());
        if (RaftServer.Roll.VOTER.name().equals(this.config.getRole()) || RaftServer.Roll.OBSERVER.name().equals(this.config.getRole())) {
            RaftServer.Roll role = RaftServer.Roll.valueOf((String)this.config.getRole());
            SQLServerAccessPoint serverAccessPoint = new SQLServerAccessPoint(journalkeeperProperties);
            if (CollectionUtils.isNotEmpty(nodes) && !nodes.contains(currentNode)) {
                this.joinCluster(currentNode, nodes, serverAccessPoint);
                nodes.add(currentNode);
            } else if (CollectionUtils.isEmpty(nodes)) {
                nodes.add(currentNode);
            }
            this.sqlServer = serverAccessPoint.createServer(currentNode, nodes, role);
            this.sqlServer.tryStart();
            this.sqlServer.waitClusterReady((long)this.config.getWaitLeaderTimeout(), TimeUnit.MILLISECONDS);
            this.sqlClient = this.sqlServer.getClient();
        } else {
            SQLClientAccessPoint clientAccessPoint = new SQLClientAccessPoint(journalkeeperProperties);
            this.sqlClient = clientAccessPoint.createClient(nodes);
        }
        this.sqlOperator = new DefaultSQLOperator(this.sqlClient);
        BatchOperationContext.init(this.sqlOperator);
        this.journalkeeperInternalServiceManager = new JournalkeeperInternalServiceManager(this.sqlServer, this.sqlClient, this.sqlOperator, this.tracer);
        this.journalkeeperInternalServiceManager.start();
    }

    protected void joinCluster(URI currentNode, List<URI> nodes, SQLServerAccessPoint serverAccessPoint) throws Exception {
        SQLServer remoteServer = serverAccessPoint.createRemoteServer(currentNode, nodes);
        ClusterConfiguration clusterConfiguration = (ClusterConfiguration)remoteServer.getAdminClient().getClusterConfiguration().get();
        logger.info("get journalkeeper cluster, leader: {}, voters: {}", (Object)clusterConfiguration.getLeader(), (Object)clusterConfiguration.getVoters());
        List currentVoters = clusterConfiguration.getVoters();
        if (!currentVoters.contains(currentNode)) {
            ArrayList newVoters = Lists.newArrayList((Iterable)currentVoters);
            nodes.clear();
            nodes.addAll(currentVoters);
            newVoters.add(currentNode);
            logger.info("update journalkeeper cluster, oldVoters: {}, newVoters: {}", (Object)currentVoters, (Object)newVoters);
            try {
                remoteServer.getAdminClient().updateVoters(currentVoters, (List)newVoters).get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                logger.warn("update journalkeeper cluster exception, oldVoters: {}, newVoters: {}", new Object[]{currentVoters, newVoters, e});
            }
        }
        remoteServer.stop();
    }

    protected static List<URI> parseNodeUris(URI currentNode, List<String> nodes) {
        ArrayList nodesUri = Lists.newArrayList();
        for (String node : nodes) {
            String[] split = node.split(":");
            nodesUri.add(URI.create(String.format("journalkeeper://%s:%s", split[0], split[1])));
        }
        return nodesUri;
    }

    protected void doStop() {
        if (this.sqlServer != null) {
            this.sqlServer.stop();
        }
        if (this.sqlClient != null) {
            this.sqlClient.stop();
        }
        if (this.journalkeeperInternalServiceManager != null) {
            this.journalkeeperInternalServiceManager.stop();
        }
    }

    public <T> T getService(Class<T> service) {
        return this.journalkeeperInternalServiceManager.getService(service);
    }

    public String type() {
        return "journalkeeper";
    }
}

