/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.helper.PortHelper;
import org.joyqueue.nsr.journalkeeper.config.JournalkeeperConfigKey;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalkeeperConfig {
    protected static final Logger logger = LoggerFactory.getLogger(JournalkeeperConfig.class);
    private PropertySupplier propertySupplier;

    public JournalkeeperConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    public int getPort() {
        return PortHelper.getJournalkeeperPort((int)((Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_PORT)));
    }

    public String getRole() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.ROLE);
    }

    public String getLocal() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.LOCAL);
    }

    public List<String> getNodes() {
        String nodes = (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.NODES);
        if (StringUtils.isBlank((CharSequence)nodes)) {
            return Collections.emptyList();
        }
        return Arrays.asList(nodes.split(","));
    }

    public int getWaitLeaderTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.WAIT_LEADER_TIMEOUT);
    }

    public String getWorkingDir() {
        String dir = (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.WORKING_DIR);
        if (StringUtils.isNotBlank((CharSequence)dir)) {
            return dir;
        }
        return this.propertySupplier.getProperty("application.data.path").getString() + "/metadata/journalkeeper";
    }

    public String getInitFile() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.INIT_FILE);
    }

    public int getSnapshotIntervalSec() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.SNAPSHOT_INTERVAL_SEC);
    }

    public int getJournalRetentionMin() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.JOURNAL_RETENTION_MIN_KEY);
    }

    public int getRpcTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.RPC_TIMEOUT);
    }

    public int getExecuteTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.EXECUTE_TIMEOUT);
    }

    public int getFlushInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.FLUSH_INTERVAL);
    }

    public int getStateBatchSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.STATE_BATCH_SIZE);
    }

    public boolean getMetricEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.METRIC_ENABLE);
    }

    public int getMetricPrintInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)JournalkeeperConfigKey.METRIC_PRINT_INTERVAL);
    }
}

