/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.nsr.journalkeeper.domain.BrokerDTO;

public class BrokerConverter {
    public static BrokerDTO convert(Broker broker) {
        if (broker == null) {
            return null;
        }
        BrokerDTO brokerDTO = new BrokerDTO();
        brokerDTO.setId((long)broker.getId());
        brokerDTO.setIp(broker.getIp());
        brokerDTO.setPort(broker.getPort());
        brokerDTO.setDataCenter(broker.getDataCenter());
        brokerDTO.setRetryType(broker.getRetryType());
        brokerDTO.setPermission(broker.getPermission().getName());
        return brokerDTO;
    }

    public static Broker convert(BrokerDTO brokerDTO) {
        if (brokerDTO == null) {
            return null;
        }
        Broker broker = new Broker();
        broker.setId(Integer.valueOf(String.valueOf(brokerDTO.getId())).intValue());
        broker.setIp(brokerDTO.getIp());
        broker.setPort(brokerDTO.getPort().intValue());
        broker.setDataCenter(brokerDTO.getDataCenter());
        broker.setRetryType(brokerDTO.getRetryType());
        broker.setPermission(Broker.PermissionEnum.value((String)brokerDTO.getPermission()));
        return broker;
    }

    public static List<Broker> convert(List<BrokerDTO> brokerDTOList) {
        if (CollectionUtils.isEmpty(brokerDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)brokerDTOList.size());
        for (BrokerDTO brokerDTO : brokerDTOList) {
            result.add(BrokerConverter.convert(brokerDTO));
        }
        return result;
    }
}

