/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Config;
import org.joyqueue.nsr.journalkeeper.domain.ConfigDTO;

public class ConfigConverter {
    public static ConfigDTO convert(Config config) {
        if (config == null) {
            return null;
        }
        ConfigDTO configDTO = new ConfigDTO();
        configDTO.setId(ConfigConverter.generateId(config));
        configDTO.setGroup(config.getGroup());
        configDTO.setKey(config.getKey());
        configDTO.setValue(config.getValue());
        return configDTO;
    }

    protected static String generateId(Config config) {
        return String.format("%s.%s", config.getGroup(), config.getKey());
    }

    public static Config convert(ConfigDTO configDTO) {
        if (configDTO == null) {
            return null;
        }
        Config config = new Config();
        config.setKey(configDTO.getKey());
        config.setValue(configDTO.getValue());
        config.setGroup(configDTO.getGroup());
        return config;
    }

    public static List<Config> convert(List<ConfigDTO> configDTOList) {
        if (CollectionUtils.isEmpty(configDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)configDTOList.size());
        for (ConfigDTO configDTO : configDTOList) {
            result.add(ConfigConverter.convert(configDTO));
        }
        return result;
    }
}

