/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.domain.TopicType;
import org.joyqueue.nsr.journalkeeper.domain.ConsumerDTO;
import org.joyqueue.nsr.journalkeeper.helper.JsonHelper;
import org.joyqueue.toolkit.retry.RetryPolicy;

public class ConsumerConverter {
    public static ConsumerDTO convert(Consumer consumer) {
        if (consumer == null) {
            return null;
        }
        ConsumerDTO consumerDTO = new ConsumerDTO();
        consumerDTO.setId(ConsumerConverter.generateId(consumer));
        consumerDTO.setClientType(consumer.getClientType().value());
        consumerDTO.setTopicType(consumer.getTopicType().code());
        consumerDTO.setRetryPolicy(JsonHelper.toJson(consumer.getRetryPolicy()));
        consumerDTO.setConsumePolicy(JsonHelper.toJson(consumer.getConsumerPolicy()));
        consumerDTO.setLimitPolicy(JsonHelper.toJson(consumer.getLimitPolicy()));
        consumerDTO.setTopic(consumer.getTopic().getCode());
        consumerDTO.setNamespace(consumer.getTopic().getNamespace());
        consumerDTO.setApp(consumer.getApp());
        consumerDTO.setReferer(consumerDTO.getApp().split("\\.")[0]);
        String[] group = consumer.getApp().split("\\.");
        if (group.length == 2) {
            consumerDTO.setGroup(group[1]);
        }
        return consumerDTO;
    }

    protected static String generateId(Consumer consumer) {
        return String.format("%s.%s", consumer.getTopic().getFullName(), consumer.getApp());
    }

    public static Consumer convert(ConsumerDTO consumerDTO) {
        if (consumerDTO == null) {
            return null;
        }
        Consumer consumer = new Consumer();
        consumer.setTopic(TopicName.parse((String)consumerDTO.getTopic(), (String)consumerDTO.getNamespace()));
        consumer.setApp(consumerDTO.getApp());
        consumer.setTopicType(TopicType.valueOf((byte)consumerDTO.getTopicType()));
        consumer.setClientType(ClientType.valueOf((int)consumerDTO.getClientType().byteValue()));
        consumer.setConsumerPolicy(JsonHelper.parseJson(Consumer.ConsumerPolicy.class, consumerDTO.getConsumePolicy()));
        consumer.setRetryPolicy(JsonHelper.parseJson(RetryPolicy.class, consumerDTO.getRetryPolicy()));
        consumer.setLimitPolicy(JsonHelper.parseJson(Consumer.ConsumerLimitPolicy.class, consumerDTO.getLimitPolicy()));
        return consumer;
    }

    public static List<Consumer> convert(List<ConsumerDTO> consumerDTOList) {
        if (CollectionUtils.isEmpty(consumerDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)consumerDTOList.size());
        for (ConsumerDTO consumerDTO : consumerDTOList) {
            result.add(ConsumerConverter.convert(consumerDTO));
        }
        return result;
    }
}

